package ru.yandex.direct.core.entity.adgroup.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.banner.model.AdGroupContainsBanners;
import ru.yandex.direct.core.entity.banner.repository.BannerRelationsRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между объявлениями и группами объявлений
 */

@ParametersAreNonnullByDefault
@Service
public class AdGroupWithBannersService implements RelationshipService<AdGroupContainsBanners, Long, Long> {
    private final ShardHelper shardHelper;
    private final BannerRelationsRepository bannerRelationsRepository;

    @Autowired
    public AdGroupWithBannersService(ShardHelper shardHelper, BannerRelationsRepository bannerRelationsRepository) {
        this.shardHelper = shardHelper;
        this.bannerRelationsRepository = bannerRelationsRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> adGroupIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return StreamEx.of(bannerRelationsRepository.getAdGroupIdToBannerIds(shard, adGroupIds).values())
                .flatMap(StreamEx::of)
                .toSet();
    }
}
