package ru.yandex.direct.core.entity.adgroup.service;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.bidmodifier.AdGroupContainsBidModifiers;
import ru.yandex.direct.core.entity.bidmodifiers.repository.BidModifierRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между корректировками и группами объявлений
 */
@ParametersAreNonnullByDefault
@Service
public class AdGroupWithBidModifiersService implements RelationshipService<AdGroupContainsBidModifiers, Long, Long> {
    private final ShardHelper shardHelper;
    private final BidModifierRepository bidModifierRepository;

    @Autowired
    public AdGroupWithBidModifiersService(ShardHelper shardHelper, BidModifierRepository bidModifierRepository) {
        this.shardHelper = shardHelper;
        this.bidModifierRepository = bidModifierRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> adGroupIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);

        return StreamEx.of(bidModifierRepository.getBidModifierIdsByAdGroupIds(shard, adGroupIds).values())
                .flatMap(Collection::stream)
                .toSet();
    }
}
