package ru.yandex.direct.core.entity.adgroup.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.AdGroupContainsDynamicAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicAdTarget;
import ru.yandex.direct.core.entity.dynamictextadtarget.model.DynamicAdTargetsQueryFilter;
import ru.yandex.direct.core.entity.dynamictextadtarget.repository.DynamicTextAdTargetRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между списком фильтров и группами ДО объявлений
 */
@ParametersAreNonnullByDefault
@Service
public class AdGroupWithDynamicAdTargetsFilterService
        implements RelationshipService<AdGroupContainsDynamicAdTarget, Long, Long> {
    private final ShardHelper shardHelper;
    private final DynamicTextAdTargetRepository dynamicTextAdTargetRepository;

    @Autowired
    public AdGroupWithDynamicAdTargetsFilterService(ShardHelper shardHelper,
                                                    DynamicTextAdTargetRepository dynamicTextAdTargetRepository) {
        this.shardHelper = shardHelper;
        this.dynamicTextAdTargetRepository = dynamicTextAdTargetRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> adGroupIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        DynamicAdTargetsQueryFilter queryFilter = new DynamicAdTargetsQueryFilter()
                .withAdGroupIds(adGroupIds)
                .withIncludeDeleted(false);
        return StreamEx.of(dynamicTextAdTargetRepository.getDynamicAdTargetsByQueryFilter(shard, clientId, queryFilter))
                .map(DynamicAdTarget::getId)
                .toSet();
    }
}
