package ru.yandex.direct.core.entity.adgroup.service;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupHasHyperGeo;
import ru.yandex.direct.core.entity.hypergeo.service.HyperGeoService;
import ru.yandex.direct.dbutil.model.ClientId;

@Service
@ParametersAreNonnullByDefault
public class AdGroupWithHyperGeoService implements RelationshipService<AdGroupHasHyperGeo, Long, Long> {

    private final HyperGeoService hyperGeoService;

    @Autowired
    public AdGroupWithHyperGeoService(HyperGeoService hyperGeoService) {
        this.hyperGeoService = hyperGeoService;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> hyperGeoIds) {
        return EntryStream.of(hyperGeoService.getAdGroupIdsByHyperGeoId(clientId, hyperGeoIds))
                .values()
                .flatMap(Collection::stream)
                .toSet();
    }
}
