package ru.yandex.direct.core.entity.adgroup.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.keyword.model.AdGroupContainsKeywords;
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между ключевыми фразами и группами объявлений
 */
@ParametersAreNonnullByDefault
@Service
public class AdGroupWithKeywordsService implements RelationshipService<AdGroupContainsKeywords, Long, Long> {
    private final ShardHelper shardHelper;
    private final KeywordRepository keywordRepository;

    @Autowired
    public AdGroupWithKeywordsService(ShardHelper shardHelper, KeywordRepository keywordRepository) {
        this.shardHelper = shardHelper;
        this.keywordRepository = keywordRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> adGroupIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);

        return StreamEx.of(keywordRepository.getKeywordIdsByAdGroupIds(shard, clientId, adGroupIds).values())
                .toSet();
    }
}
