package ru.yandex.direct.core.entity.adgroup.service

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Service
import ru.yandex.direct.core.copyentity.RelationshipService
import ru.yandex.direct.core.entity.offerretargeting.model.AdGroupContainsOfferRetargeting
import ru.yandex.direct.core.entity.offerretargeting.repository.OfferRetargetingRepository
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.dbutil.sharding.ShardHelper
import javax.annotation.ParametersAreNonnullByDefault

/**
 * Сервис связки между офферными ретаргетингами и группами объявлений
 */
@ParametersAreNonnullByDefault
@Service
class AdGroupWithOfferRetargetingsService @Autowired constructor(
    private val shardHelper: ShardHelper,
    private val offerRetargetingRepository: OfferRetargetingRepository
) : RelationshipService<AdGroupContainsOfferRetargeting, Long, Long> {

    override fun getChildEntityIdsByParentIds(clientId: ClientId, operatorId: Long, adGroupIds: Set<Long>): Set<Long> {
        val shard = shardHelper.getShardByClientIdStrictly(clientId)
        val offerRetargetings = offerRetargetingRepository.getOfferRetargetingIdsByAdGroupIds(shard, clientId, adGroupIds)
        return offerRetargetings.asSequence().flatMap { it.value }.toSet()
    }
}
