package ru.yandex.direct.core.entity.adgroup.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.performancefilter.model.AdGroupContainsPerformanceFilter;
import ru.yandex.direct.core.entity.performancefilter.repository.PerformanceFilterRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между списком фильтров и группами объявлений
 */
@ParametersAreNonnullByDefault
@Service
public class AdGroupWithPerformanceFilterService
        implements RelationshipService<AdGroupContainsPerformanceFilter, Long, Long> {
    private final ShardHelper shardHelper;
    private final PerformanceFilterRepository performanceFilterRepository;

    @Autowired
    public AdGroupWithPerformanceFilterService(ShardHelper shardHelper,
                                               PerformanceFilterRepository performanceFilterRepository) {
        this.shardHelper = shardHelper;
        this.performanceFilterRepository = performanceFilterRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> adGroupIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return StreamEx.of(performanceFilterRepository.getFilterIdsByAdGroupIds(shard, adGroupIds).values())
                .flatMap(StreamEx::of)
                .toSet();
    }
}
