package ru.yandex.direct.core.entity.adgroup.service;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.copyentity.RelationshipService;
import ru.yandex.direct.core.entity.relevancematch.model.AdGroupContainsRelevanceMatches;
import ru.yandex.direct.core.entity.relevancematch.repository.RelevanceMatchRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

/**
 * Сервис связки между автотаргетингами и группами объявлений
 */
@ParametersAreNonnullByDefault
@Service
public class AdGroupWithRelevanceMatchesService implements
        RelationshipService<AdGroupContainsRelevanceMatches, Long, Long> {
    private final ShardHelper shardHelper;
    private final RelevanceMatchRepository relevanceMatchRepository;

    @Autowired
    public AdGroupWithRelevanceMatchesService(ShardHelper shardHelper,
                                              RelevanceMatchRepository relevanceMatchRepository) {
        this.shardHelper = shardHelper;
        this.relevanceMatchRepository = relevanceMatchRepository;
    }

    @Override
    public Set<Long> getChildEntityIdsByParentIds(ClientId clientId, Long operatorId, Set<Long> adGroupIds) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);

        var relevanceMatches = relevanceMatchRepository.getRelevanceMatchIdsByAdGroupIds(shard, clientId, adGroupIds);
        return StreamEx.of(relevanceMatches.values()).toSet();
    }
}
