package ru.yandex.direct.core.entity.adgroup.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.bstags.AdGroupBsTagsSettingsProvider;
import ru.yandex.direct.core.entity.adgroup.service.geotree.AdGroupGeoTreeProviderFactory;
import ru.yandex.direct.core.entity.adgroup.service.validation.AddAdGroupValidationService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.service.ClientGeoService;
import ru.yandex.direct.core.entity.crypta.repository.CryptaSegmentRepository;
import ru.yandex.direct.core.entity.hypergeo.repository.HyperGeoRepository;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.core.entity.minuskeywordspack.service.AddMinusKeywordsPackSubOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;

@Component
public class AdGroupsAddOperationFactory {
    private final CampaignRepository campaignRepository;
    private final AdGroupRepository adGroupRepository;
    private final HyperGeoRepository hyperGeoRepository;
    private final CryptaSegmentRepository cryptaSegmentRepository;
    private final AddAdGroupValidationService addValidationService;
    private final ClientGeoService clientGeoService;
    private final AdGroupOperationsHelper adGroupOperationsHelper;
    private final AdGroupGeoTreeProviderFactory geoTreeProviderFactory;
    private final AdGroupBsTagsSettingsProvider adGroupBsTagsSettingsProvider;
    private final AddMinusKeywordsPackSubOperationFactory addMinusKeywordsPackSubOperationFactory;
    private final DslContextProvider dslContextProvider;

    @Autowired
    public AdGroupsAddOperationFactory(
            CampaignRepository campaignRepository,
            AdGroupRepository adGroupRepository,
            HyperGeoRepository hyperGeoRepository,
            AddAdGroupValidationService addValidationService,
            ClientGeoService clientGeoService,
            CryptaSegmentRepository cryptaSegmentRepository,
            AdGroupOperationsHelper adGroupOperationsHelper,
            AdGroupGeoTreeProviderFactory geoTreeProviderFactory,
            AdGroupBsTagsSettingsProvider adGroupBsTagsSettingsProvider,
            AddMinusKeywordsPackSubOperationFactory addMinusKeywordsPackSubOperationFactory,
            DslContextProvider dslContextProvider) {
        this.campaignRepository = campaignRepository;
        this.adGroupRepository = adGroupRepository;
        this.hyperGeoRepository = hyperGeoRepository;
        this.cryptaSegmentRepository = cryptaSegmentRepository;
        this.addValidationService = addValidationService;
        this.clientGeoService = clientGeoService;
        this.adGroupOperationsHelper = adGroupOperationsHelper;
        this.geoTreeProviderFactory = geoTreeProviderFactory;
        this.adGroupBsTagsSettingsProvider = adGroupBsTagsSettingsProvider;
        this.addMinusKeywordsPackSubOperationFactory = addMinusKeywordsPackSubOperationFactory;
        this.dslContextProvider = dslContextProvider;
    }

    public AdGroupsAddOperation newInstance(
            Applicability applicability,
            List<AdGroup> adGroups,
            GeoTree defaultGeoTree,
            MinusPhraseValidator.ValidationMode minusPhraseValidationMode,
            long operatorUid, ClientId clientId, int shard, boolean saveDraft, boolean refineGeo) {
        return new AdGroupsAddOperation(
                applicability,
                adGroups,
                campaignRepository,
                adGroupRepository,
                hyperGeoRepository,
                cryptaSegmentRepository,
                addValidationService,
                adGroupBsTagsSettingsProvider,
                addMinusKeywordsPackSubOperationFactory,
                dslContextProvider,
                defaultGeoTree,
                geoTreeProviderFactory,
                clientGeoService,
                adGroupOperationsHelper,
                minusPhraseValidationMode,
                operatorUid,
                clientId,
                shard,
                saveDraft,
                refineGeo);
    }
}
