package ru.yandex.direct.core.entity.adgroup.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.container.AdGroupUpdateOperationParams;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.bstags.AdGroupBsTagsSettingsProvider;
import ru.yandex.direct.core.entity.adgroup.service.geotree.AdGroupGeoTreeProviderFactory;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupUpdateServices;
import ru.yandex.direct.core.entity.adgroup.service.validation.UpdateAdGroupValidationService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.service.ClientGeoService;
import ru.yandex.direct.core.entity.crypta.repository.CryptaSegmentRepository;
import ru.yandex.direct.core.entity.hypergeo.repository.HyperGeoRepository;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.core.entity.minuskeywordspack.service.AddMinusKeywordsPackSubOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;

@Component
public class AdGroupsUpdateOperationFactory {
    private final CampaignRepository campaignRepository;
    private final AdGroupRepository adGroupRepository;
    private final HyperGeoRepository hyperGeoRepository;
    private final CryptaSegmentRepository cryptaSegmentRepository;
    private final UpdateAdGroupValidationService updateValidationService;
    private final AdGroupUpdateServices updateServices;
    private final AdGroupBsTagsSettingsProvider adGroupBsTagsSettingsProvider;
    private final AddMinusKeywordsPackSubOperationFactory addMinusKeywordsPackSubOperationFactory;
    private final ClientGeoService clientGeoService;
    private final AdGroupGeoTreeProviderFactory geoTreeProviderFactory;
    private final AdGroupOperationsHelper adGroupOperationsHelper;

    @Autowired
    public AdGroupsUpdateOperationFactory(
            CampaignRepository campaignRepository,
            AdGroupRepository adGroupRepository,
            HyperGeoRepository hyperGeoRepository,
            CryptaSegmentRepository cryptaSegmentRepository,
            UpdateAdGroupValidationService updateValidationService,
            AdGroupUpdateServices updateServices,
            AdGroupBsTagsSettingsProvider adGroupBsTagsSettingsProvider,
            AddMinusKeywordsPackSubOperationFactory addMinusKeywordsPackSubOperationFactory,
            ClientGeoService clientGeoService,
            AdGroupGeoTreeProviderFactory geoTreeProviderFactory,
            AdGroupOperationsHelper adGroupOperationsHelper) {
        this.campaignRepository = campaignRepository;
        this.adGroupRepository = adGroupRepository;
        this.hyperGeoRepository = hyperGeoRepository;
        this.cryptaSegmentRepository = cryptaSegmentRepository;
        this.updateValidationService = updateValidationService;
        this.updateServices = updateServices;
        this.adGroupBsTagsSettingsProvider = adGroupBsTagsSettingsProvider;
        this.addMinusKeywordsPackSubOperationFactory = addMinusKeywordsPackSubOperationFactory;
        this.clientGeoService = clientGeoService;
        this.geoTreeProviderFactory = geoTreeProviderFactory;
        this.adGroupOperationsHelper = adGroupOperationsHelper;
    }

    public AdGroupsUpdateOperation newInstance(
            Applicability applicability,
            List<ModelChanges<AdGroup>> modelChangesList,
            AdGroupUpdateOperationParams operationParams,
            GeoTree defaultGeoTree,
            MinusPhraseValidator.ValidationMode minusPhraseValidationMode,
            Long operatorUid,
            ClientId clientId,
            int shard) {
        return new AdGroupsUpdateOperation(
                applicability,
                modelChangesList,
                operationParams,
                campaignRepository,
                adGroupRepository,
                hyperGeoRepository,
                cryptaSegmentRepository,
                updateValidationService,
                defaultGeoTree,
                geoTreeProviderFactory,
                clientGeoService,
                updateServices,
                adGroupOperationsHelper,
                adGroupBsTagsSettingsProvider,
                addMinusKeywordsPackSubOperationFactory,
                minusPhraseValidationMode,
                operatorUid,
                clientId,
                shard
        );
    }
}
