package ru.yandex.direct.core.entity.adgroup.service;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingJoinType;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargetingMode;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ContentCategoriesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.retargeting.model.CryptaInterestType;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.core.entity.retargeting.model.RuleType;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@ParametersAreNonnullByDefault
public class ContentCategoriesTargetingConverter {

    private ContentCategoriesTargetingConverter() {
    }

    public static Rule toRule(ContentCategoriesAdGroupAdditionalTargeting additionalTargeting) {
        var goals = mapList(additionalTargeting.getValue(),
                goalId -> (Goal) new Goal().withId(goalId).withType(Goal.computeType(goalId)));

        return new Rule()
                .withGoals(goals)
                .withInterestType(CryptaInterestType.all)
                .withType(getRuleType(additionalTargeting));
    }

    public static ContentCategoriesAdGroupAdditionalTargeting toTargeting(Rule rule) {
        var targeting = new ContentCategoriesAdGroupAdditionalTargeting()
                .withValue(listToSet(rule.getGoals(), Goal::getId));

        switch (rule.getType()) {
            case OR:
                targeting.withTargetingMode(AdGroupAdditionalTargetingMode.TARGETING)
                        .withJoinType(AdGroupAdditionalTargetingJoinType.ANY);
                break;
            case ALL:
                targeting.withTargetingMode(AdGroupAdditionalTargetingMode.TARGETING)
                        .withJoinType(AdGroupAdditionalTargetingJoinType.ALL);
                break;
            case NOT:
                targeting.withTargetingMode(AdGroupAdditionalTargetingMode.FILTERING)
                        .withJoinType(AdGroupAdditionalTargetingJoinType.ALL);
                break;
        }

        return targeting;
    }

    private static RuleType getRuleType(ContentCategoriesAdGroupAdditionalTargeting additionalTargeting) {
        if (AdGroupAdditionalTargetingMode.TARGETING.equals(additionalTargeting.getTargetingMode())) {
            if (AdGroupAdditionalTargetingJoinType.ANY.equals(additionalTargeting.getJoinType())) {
                return RuleType.OR;
            } else if (AdGroupAdditionalTargetingJoinType.ALL.equals(additionalTargeting.getJoinType())) {
                return RuleType.ALL;
            }
        }

        if (AdGroupAdditionalTargetingJoinType.ALL.equals(additionalTargeting.getJoinType())
                && AdGroupAdditionalTargetingMode.FILTERING.equals(additionalTargeting.getTargetingMode())) {
            return RuleType.NOT;
        }

        return null;
    }
}
