package ru.yandex.direct.core.entity.adgroup.service;

public enum ModerationMode {

    /**
     * Если при редактировании группа в статусе черновика (StatusModerate.NEW),
     * то она остается в этом статусе независимо от характера изменений.
     * Если кампания данной группы находится в статусе черновика,
     * то группа сохраняется в статусе черновика.
     * Если группа и кампания не являются черновиками, то при значимых изменениях группа
     * отправляется на модерацию.
     * <p>
     * Если группа отправляется на модерацию, а кампания находится в статусе "отклонена на модерации",
     * то и кампания переотправляется на модерацию.
     */
    DEFAULT,

    /**
     * Группа принудительно сохраняется в статусе StatusModerate.New (черновик)
     * независимо от предыдущего статуса и характера изменений.
     */
    FORCE_SAVE_DRAFT,

    /**
     * Если группа была черновиком и при этом кампания не является черновиком,
     * то группа отправляется на модерацию.
     * Если группа не была черновиком и при этом кампания не является черновиком,
     * то группа отправляется на модерацию при значимых изменениях.
     * Если кампания является черновиком, то группа сохраняется в статусе черновика.
     * <p>
     * Если группа отправляется на модерацию, а кампания находится в статусе "отклонена на модерации",
     * то и кампания переотправляется на модерацию.
     */
    FORCE_MODERATE;

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public boolean isForceSaveDraft() {
        return this == FORCE_SAVE_DRAFT;
    }

    public boolean isForceModerate() {
        return this == FORCE_MODERATE;
    }
}
