package ru.yandex.direct.core.entity.adgroup.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.container.AdGroupNewMinusKeywords;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.bstags.AdGroupBsTagsSettingsProvider;
import ru.yandex.direct.core.entity.adgroup.service.geotree.AdGroupGeoTreeProviderFactory;
import ru.yandex.direct.core.entity.adgroup.service.update.AdGroupUpdateServices;
import ru.yandex.direct.core.entity.adgroup.service.validation.UpdateAdGroupValidationService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.service.ClientGeoService;
import ru.yandex.direct.core.entity.crypta.repository.CryptaSegmentRepository;
import ru.yandex.direct.core.entity.hypergeo.repository.HyperGeoRepository;
import ru.yandex.direct.core.entity.keyword.processing.KeywordNormalizer;
import ru.yandex.direct.core.entity.keyword.processing.KeywordStopwordsFixer;
import ru.yandex.direct.core.entity.minuskeywordspack.repository.MinusKeywordsPackRepository;
import ru.yandex.direct.core.entity.minuskeywordspack.service.AddMinusKeywordsPackSubOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;

@Component
public class UpdateAdGroupMinusKeywordsOperationFactory {
    private final CampaignRepository campaignRepository;
    private final AdGroupRepository adGroupRepository;
    private final HyperGeoRepository hyperGeoRepository;
    private final CryptaSegmentRepository cryptaSegmentRepository;
    private final MinusKeywordsPackRepository minusKeywordsPackRepository;
    private final UpdateAdGroupValidationService updateValidationService;
    private final MinusKeywordPreparingTool minusKeywordPreparingTool;
    private final KeywordStopwordsFixer keywordStopwordsFixer;
    private final KeywordNormalizer keywordNormalizer;
    private final AdGroupUpdateServices updateServices;
    private final AdGroupOperationsHelper adGroupOperationsHelper;
    private final AdGroupBsTagsSettingsProvider adGroupBsTagsSettingsProvider;
    private final AddMinusKeywordsPackSubOperationFactory addMinusKeywordsPackSubOperationFactory;
    private final ClientGeoService clientGeoService;
    private final AdGroupGeoTreeProviderFactory geoTreeProviderFactory;

    @Autowired
    public UpdateAdGroupMinusKeywordsOperationFactory(
            CampaignRepository campaignRepository,
            AdGroupRepository adGroupRepository,
            HyperGeoRepository hyperGeoRepository,
            CryptaSegmentRepository cryptaSegmentRepository,
            MinusKeywordsPackRepository minusKeywordsPackRepository,
            UpdateAdGroupValidationService updateValidationService,
            MinusKeywordPreparingTool minusKeywordPreparingTool,
            KeywordStopwordsFixer keywordStopwordsFixer,
            KeywordNormalizer keywordNormalizer,
            AdGroupUpdateServices updateServices,
            AdGroupOperationsHelper adGroupOperationsHelper,
            AdGroupBsTagsSettingsProvider adGroupBsTagsSettingsProvider,
            AddMinusKeywordsPackSubOperationFactory addMinusKeywordsPackSubOperationFactory,
            ClientGeoService clientGeoService,
            AdGroupGeoTreeProviderFactory geoTreeProviderFactory) {
        this.campaignRepository = campaignRepository;
        this.adGroupRepository = adGroupRepository;
        this.hyperGeoRepository = hyperGeoRepository;
        this.cryptaSegmentRepository = cryptaSegmentRepository;
        this.minusKeywordsPackRepository = minusKeywordsPackRepository;
        this.updateValidationService = updateValidationService;
        this.minusKeywordPreparingTool = minusKeywordPreparingTool;
        this.keywordStopwordsFixer = keywordStopwordsFixer;
        this.keywordNormalizer = keywordNormalizer;
        this.updateServices = updateServices;
        this.adGroupOperationsHelper = adGroupOperationsHelper;
        this.adGroupBsTagsSettingsProvider = adGroupBsTagsSettingsProvider;
        this.addMinusKeywordsPackSubOperationFactory = addMinusKeywordsPackSubOperationFactory;
        this.clientGeoService = clientGeoService;
        this.geoTreeProviderFactory = geoTreeProviderFactory;
    }

    public UpdateAdGroupMinusKeywordsOperation newInstance(
            Applicability applicability,
            List<AdGroupNewMinusKeywords> adGroupNewMinusKeywordsList,
            GeoTree defaultGeoTree, UpdateMinusKeywordsMode updateMode,
            long operatorUid, ClientId clientId, int shard) {
        return new UpdateAdGroupMinusKeywordsOperation(
                applicability,
                adGroupNewMinusKeywordsList,
                campaignRepository,
                adGroupRepository,
                hyperGeoRepository,
                cryptaSegmentRepository,
                minusKeywordsPackRepository,
                updateValidationService,
                minusKeywordPreparingTool,
                keywordStopwordsFixer,
                keywordNormalizer,
                defaultGeoTree,
                geoTreeProviderFactory,
                clientGeoService,
                updateServices,
                adGroupBsTagsSettingsProvider,
                addMinusKeywordsPackSubOperationFactory,
                adGroupOperationsHelper,
                updateMode,
                operatorUid,
                clientId,
                shard);
    }
}
