package ru.yandex.direct.core.entity.adgroup.service.bstags;

import java.util.IdentityHashMap;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;

import static ru.yandex.direct.core.entity.adgroup.service.bstags.AdGroupBsTagsUtils.entryStreamOfAdGroups;

@ParametersAreNonnullByDefault
public abstract class AbstractAdGroupBsTagsTypeSupport<T extends AdGroup> implements AdGroupBsTagsTypeSupport<T> {

    @Override
    public IdentityHashMap<AdGroup, AdGroupBsTagsSettings> getAdGroupsBsTagsSettings(
            List<T> adGroups, GetAdGroupsBsTagsSettingsParams params) {
        return entryStreamOfAdGroups(adGroups)
                .mapValues(adGroup -> getAdGroupBsTagsSettings(adGroup, params))
                .toCustomMap(IdentityHashMap::new);
    }

    protected abstract AdGroupBsTagsSettings getAdGroupBsTagsSettings(
            T adGroup, GetAdGroupsBsTagsSettingsParams params);

}
