package ru.yandex.direct.core.entity.adgroup.service.bstags;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.dbutil.model.ClientId;

import static java.util.stream.Collectors.groupingBy;

@Component
@ParametersAreNonnullByDefault
public class AdGroupBsTagsSettingsProvider {

    private final Map<Class, AdGroupBsTagsTypeSupport> supportsByType;
    private final DefaultAdGroupBsTagsTypeSupport defaultSupport;

    @Autowired
    public AdGroupBsTagsSettingsProvider(List<AdGroupBsTagsTypeSupport<? extends AdGroup>> supports) {
        this.supportsByType = StreamEx.of(supports)
                .toMap(AdGroupBsTagsTypeSupport::getAdGroupClass, Function.identity());
        this.defaultSupport = new DefaultAdGroupBsTagsTypeSupport();
    }

    public IdentityHashMap<AdGroup, AdGroupBsTagsSettings> getAdGroupBsTagsSettings(
            List<AdGroup> adGroups, ClientId clientId) {
        var params = new GetAdGroupsBsTagsSettingsParams(clientId);
        var adGroupToBsTags = new IdentityHashMap<AdGroup, AdGroupBsTagsSettings>();
        var adGroupsByClass = adGroups.stream().collect(groupingBy(Object::getClass));
        EntryStream.of(adGroupsByClass)
                .forKeyValue((clazz, adGroupsOfClass) -> {
                    AdGroupBsTagsTypeSupport supportForType = supportsByType.getOrDefault(clazz, defaultSupport);
                    IdentityHashMap<AdGroup, AdGroupBsTagsSettings> adGroupsBsTagsOfClass =
                            supportForType.getAdGroupsBsTagsSettings(adGroupsOfClass, params);
                    adGroupToBsTags.putAll(adGroupsBsTagsOfClass);
                });
        return adGroupToBsTags;
    }
}
