package ru.yandex.direct.core.entity.adgroup.service.bstags;

import java.util.IdentityHashMap;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;

@ParametersAreNonnullByDefault
public interface AdGroupBsTagsTypeSupport<T extends AdGroup> {

    Class<T> getAdGroupClass();

    /**
     * Для переданных групп возвращает ограничения для bs tag'ов.
     * <p>
     * Возвращает IdentityHashMap чтобы обеспечить сохранение дубликатов относительно equals:
     * модели могут меняться в последующем, в таком случае HashMap будет терять записи.
     * <p>
     * В качестве параметров используется отдельный объект {@link GetAdGroupsBsTagsSettingsParams}:
     * не всем суппортам нужны все параметры, а чаще всего только их часть
     * если в последующем надо будет добавить новый параметр, можно будет его добавить не ломая обратную совместимость.
     */
    IdentityHashMap<AdGroup, AdGroupBsTagsSettings> getAdGroupsBsTagsSettings(
            List<T> adGroups, GetAdGroupsBsTagsSettingsParams params);
}
