package ru.yandex.direct.core.entity.adgroup.service.bstags;

import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.adgroup.model.PageGroupTagEnum;
import ru.yandex.direct.core.entity.adgroup.model.TargetTagEnum;

import static java.util.Collections.emptyList;

@Component
@ParametersAreNonnullByDefault
class ContentPromotionAdGroupBsTagsTypeSupport extends AbstractAdGroupBsTagsTypeSupport<ContentPromotionAdGroup> {

    private static final Map<ContentPromotionAdgroupType, List<PageGroupTagEnum>>
            PAGE_GROUP_TAGS_BY_CONTENT_PROMOTION_TYPE = Map.of(
            ContentPromotionAdgroupType.VIDEO, List.of(PageGroupTagEnum.CONTENT_PROMOTION_VIDEO_TAG),
            ContentPromotionAdgroupType.COLLECTION, List.of(PageGroupTagEnum.CONTENT_PROMOTION_COLLECTION_TAG),
            ContentPromotionAdgroupType.SERVICE, List.of(PageGroupTagEnum.YDO_ADGROUP_BS_TAG),
            ContentPromotionAdgroupType.EDA, List.of(PageGroupTagEnum.EDA_ADGROUP_BS_TAG));

    private static final Map<ContentPromotionAdgroupType, List<TargetTagEnum>>
            TARGET_TAGS_BY_CONTENT_PROMOTION_TYPE = Map.of(
            ContentPromotionAdgroupType.VIDEO, List.of(TargetTagEnum.CONTENT_PROMOTION_VIDEO_TAG),
            ContentPromotionAdgroupType.COLLECTION, List.of(TargetTagEnum.CONTENT_PROMOTION_COLLECTION_TAG),
            ContentPromotionAdgroupType.SERVICE, List.of(TargetTagEnum.YDO_ADGROUP_BS_TAG),
            ContentPromotionAdgroupType.EDA, List.of(TargetTagEnum.EDA_ADGROUP_BS_TAG));

    @Override
    public Class<ContentPromotionAdGroup> getAdGroupClass() {
        return ContentPromotionAdGroup.class;
    }

    protected AdGroupBsTagsSettings getAdGroupBsTagsSettings(ContentPromotionAdGroup adGroup,
                                                             GetAdGroupsBsTagsSettingsParams params) {
        var contentPromotionType = adGroup.getContentPromotionType();
        if (contentPromotionType == null) {
            return new AdGroupBsTagsSettings.Builder().build();
        }

        var pageGroupTags = PAGE_GROUP_TAGS_BY_CONTENT_PROMOTION_TYPE.getOrDefault(contentPromotionType, emptyList());
        var targetTags = TARGET_TAGS_BY_CONTENT_PROMOTION_TYPE.getOrDefault(contentPromotionType, emptyList());

        return new AdGroupBsTagsSettings.Builder()
                .withRequiredPageGroupTagsEnum(pageGroupTags)
                .withRequiredTargetTagsEnum(targetTags)
                .build();
    }
}
