package ru.yandex.direct.core.entity.adgroup.service.bstags;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionVideoAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.PageGroupTagEnum;
import ru.yandex.direct.core.entity.adgroup.model.TargetTagEnum;

@Component
@ParametersAreNonnullByDefault
class ContentPromotionVideoAdGroupBsTagsTypeSupport extends AbstractAdGroupBsTagsTypeSupport<ContentPromotionVideoAdGroup> {

    private static final AdGroupBsTagsSettings BS_TAGS_SETTINGS = new AdGroupBsTagsSettings.Builder()
            .withRequiredPageGroupTagsEnum(List.of(PageGroupTagEnum.CONTENT_PROMOTION_VIDEO_TAG))
            .withRequiredTargetTagsEnum(List.of(TargetTagEnum.CONTENT_PROMOTION_VIDEO_TAG))
            .build();

    @Override
    public Class<ContentPromotionVideoAdGroup> getAdGroupClass() {
        return ContentPromotionVideoAdGroup.class;
    }

    protected AdGroupBsTagsSettings getAdGroupBsTagsSettings(ContentPromotionVideoAdGroup adGroup,
                                                             GetAdGroupsBsTagsSettingsParams params) {
        return BS_TAGS_SETTINGS;
    }
}
