package ru.yandex.direct.core.entity.adgroup.service.bstags;

import java.util.IdentityHashMap;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmAudioAdGroup;
import ru.yandex.direct.core.entity.pricepackage.service.PricePackageService;

@Component
@ParametersAreNonnullByDefault
public class CpmAudioAdGroupBsTagsTypeSupport implements AdGroupBsTagsTypeSupport<CpmAudioAdGroup> {

    private final PricePackageService pricePackageService;

    @Autowired
    public CpmAudioAdGroupBsTagsTypeSupport(
            PricePackageService pricePackageService) {
        this.pricePackageService = pricePackageService;
    }

    @Override
    public Class<CpmAudioAdGroup> getAdGroupClass() {
        return CpmAudioAdGroup.class;
    }

    @Override
    public IdentityHashMap<AdGroup, AdGroupBsTagsSettings> getAdGroupsBsTagsSettings(
            List<CpmAudioAdGroup> adGroups, GetAdGroupsBsTagsSettingsParams params)
    {
        return pricePackageService.getAdGroupBsTagsSettings(adGroups, params.getClientId());
    }

}
