package ru.yandex.direct.core.entity.adgroup.service.bstags;

import java.util.IdentityHashMap;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmBannerAdGroup;
import ru.yandex.direct.core.entity.pricepackage.service.PricePackageService;

@Component
@ParametersAreNonnullByDefault
public class CpmBannerAdGroupBsTagsTypeSupport implements AdGroupBsTagsTypeSupport<CpmBannerAdGroup> {

    private final PricePackageService pricePackageService;

    @Autowired
    public CpmBannerAdGroupBsTagsTypeSupport(
            PricePackageService pricePackageService) {
        this.pricePackageService = pricePackageService;
    }

    @Override
    public Class<CpmBannerAdGroup> getAdGroupClass() {
        return CpmBannerAdGroup.class;
    }

    @Override
    public IdentityHashMap<AdGroup, AdGroupBsTagsSettings> getAdGroupsBsTagsSettings(
            List<CpmBannerAdGroup> adGroups, GetAdGroupsBsTagsSettingsParams params)
    {
        return pricePackageService.getAdGroupBsTagsSettings(adGroups, params.getClientId());
    }

}
