package ru.yandex.direct.core.entity.adgroup.service.bstags;

import java.util.IdentityHashMap;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.CpmVideoAdGroup;
import ru.yandex.direct.core.entity.pricepackage.service.PricePackageService;

@Component
@ParametersAreNonnullByDefault
public class CpmVideoAdGroupBsTagsTypeSupport implements AdGroupBsTagsTypeSupport<CpmVideoAdGroup> {

    private final PricePackageService pricePackageService;

    @Autowired
    public CpmVideoAdGroupBsTagsTypeSupport(
            PricePackageService pricePackageService) {
        this.pricePackageService = pricePackageService;
    }

    @Override
    public Class<CpmVideoAdGroup> getAdGroupClass() {
        return CpmVideoAdGroup.class;
    }

    @Override
    public IdentityHashMap<AdGroup, AdGroupBsTagsSettings> getAdGroupsBsTagsSettings(
            List<CpmVideoAdGroup> adGroups, GetAdGroupsBsTagsSettingsParams params)
    {
        return pricePackageService.getAdGroupBsTagsSettings(adGroups, params.getClientId());
    }

}
