package ru.yandex.direct.core.entity.adgroup.service.bstags;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.model.CpmYndxFrontpageAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.PageGroupTagEnum;
import ru.yandex.direct.core.entity.adgroup.model.TargetTagEnum;

@Component
@ParametersAreNonnullByDefault
class CpmYndxFrontpageAdGroupBsTagsTypeSupport extends AbstractAdGroupBsTagsTypeSupport<CpmYndxFrontpageAdGroup> {

    private static final AdGroupBsTagsSettings BS_TAGS_CONSTRAINTS = new AdGroupBsTagsSettings.Builder()
            .withRequiredPageGroupTagsEnum(List.of(PageGroupTagEnum.FRONTPAGE_TAG))
            .withRequiredTargetTagsEnum(List.of(TargetTagEnum.FRONTPAGE_TAG))
            .build();

    @Override
    public Class<CpmYndxFrontpageAdGroup> getAdGroupClass() {
        return CpmYndxFrontpageAdGroup.class;
    }

    @Override
    protected AdGroupBsTagsSettings getAdGroupBsTagsSettings(
            CpmYndxFrontpageAdGroup adGroup, GetAdGroupsBsTagsSettingsParams params) {
        return BS_TAGS_CONSTRAINTS;
    }
}
