package ru.yandex.direct.core.entity.adgroup.service.complex;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupsAddOperation;
import ru.yandex.direct.core.entity.keyword.service.validation.phrase.minusphrase.MinusPhraseValidator;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class ComplexAdGroupAddOperation<T extends ComplexAdGroup> extends AbstractComplexAdGroupOperation<T, AdGroupsAddOperation> {
    public ComplexAdGroupAddOperation(Applicability applicability, boolean saveDraft, AdGroupService adGroupService,
                                      List<T> complexAdGroups, GeoTree geoTree, long operatorUid, ClientId clientId,
                                      boolean refineGeo) {
        super(applicability, complexAdGroups, clientId, adGroupService.createAddOperation(
                mapList(complexAdGroups, ComplexAdGroup::getAdGroup), geoTree,
                MinusPhraseValidator.ValidationMode.ONE_ERROR_PER_TYPE_AND_KEYWORD,
                operatorUid, clientId, applicability, saveDraft, refineGeo));
    }
}
