package ru.yandex.direct.core.entity.adgroup.service.complex;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.container.ComplexContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexCpmAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexDynamicAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexMcBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexMobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexPerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.contentpromotion.AddComplexContentPromotionAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.contentpromotion.ComplexContentPromotionAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.cpm.AddComplexCpmAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.cpm.ComplexCpmAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.cpm.PriceBidModifierPlatformChooser;
import ru.yandex.direct.core.entity.adgroup.service.complex.dynamic.ComplexDynamicAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.mcbanner.AddComplexMcBannerAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.mcbanner.ComplexMcBannerAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.mobilecontent.AddComplexMobileContentAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.mobilecontent.ComplexMobileContentAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.performance.AddComplexPerformanceAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.performance.ComplexPerformanceAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.text.AddComplexTextAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.text.ComplexTextAdGroupAddOperation;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.currency.service.CpmYndxFrontpageCurrencyService;
import ru.yandex.direct.core.entity.keyword.service.KeywordOperationFactory;
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingService;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.userssegments.service.UsersSegmentService;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;

@Component
@ParametersAreNonnullByDefault
public class ComplexAdGroupAddOperationFactory {

    private final ShardHelper shardHelper;
    private final ClientService clientService;
    private final AdGroupService adGroupService;
    private final KeywordOperationFactory keywordOperationFactory;
    private final RetargetingConditionOperationFactory retargetingConditionOperationFactory;
    private final RelevanceMatchService relevanceMatchService;
    private final OfferRetargetingService offerRetargetingService;
    private final RetargetingService retargetingService;
    private final BidModifierService bidModifierService;
    private final ComplexBidModifierService complexBidModifierService;
    private final VcardService vcardService;
    private final SitelinkSetService sitelinkSetService;
    private final CampaignRepository campaignRepository;
    private final UsersSegmentService usersSegmentService;
    private final CpmYndxFrontpageCurrencyService cpmYndxFrontpageCurrencyService;
    private final BannersAddOperationFactory bannersAddOperationFactory;

    private final AddComplexTextAdGroupValidationService textAddValidationService;
    private final AddComplexCpmAdGroupValidationService cpmAddValidationService;
    private final AddComplexContentPromotionAdGroupValidationService contentPromotionAddValidationService;
    private final AddComplexMcBannerAdGroupValidationService mcBannerAddValidationService;
    private final AddComplexMobileContentAdGroupValidationService mobileContentAddValidationService;
    private final AddComplexPerformanceAdGroupValidationService performanceAddValidationService;
    private final PriceBidModifierPlatformChooser priceBidModifierPlatformChooser;

    public ComplexAdGroupAddOperationFactory(
            ShardHelper shardHelper,
            ClientService clientService,
            AdGroupService adGroupService,
            KeywordOperationFactory keywordOperationFactory,
            RetargetingConditionOperationFactory retargetingConditionOperationFactory,
            RelevanceMatchService relevanceMatchService,
            OfferRetargetingService offerRetargetingService,
            RetargetingService retargetingService,
            BidModifierService bidModifierService,
            ComplexBidModifierService complexBidModifierService,
            VcardService vcardService,
            SitelinkSetService sitelinkSetService,
            CampaignRepository campaignRepository,
            UsersSegmentService usersSegmentService,
            CpmYndxFrontpageCurrencyService cpmYndxFrontpageCurrencyService,
            BannersAddOperationFactory bannersAddOperationFactory,
            AddComplexTextAdGroupValidationService textAddValidationService,
            AddComplexCpmAdGroupValidationService cpmAddValidationService,
            AddComplexContentPromotionAdGroupValidationService contentPromotionAddValidationService,
            AddComplexMcBannerAdGroupValidationService mcBannerAddValidationService,
            AddComplexMobileContentAdGroupValidationService mobileContentAddValidationService,
            AddComplexPerformanceAdGroupValidationService performanceAddValidationService,
            PriceBidModifierPlatformChooser priceBidModifierPlatformChooser) {
        this.shardHelper = shardHelper;
        this.clientService = clientService;
        this.adGroupService = adGroupService;
        this.keywordOperationFactory = keywordOperationFactory;
        this.retargetingConditionOperationFactory = retargetingConditionOperationFactory;
        this.relevanceMatchService = relevanceMatchService;
        this.offerRetargetingService = offerRetargetingService;
        this.retargetingService = retargetingService;
        this.bidModifierService = bidModifierService;
        this.complexBidModifierService = complexBidModifierService;
        this.vcardService = vcardService;
        this.sitelinkSetService = sitelinkSetService;
        this.campaignRepository = campaignRepository;
        this.usersSegmentService = usersSegmentService;
        this.cpmYndxFrontpageCurrencyService = cpmYndxFrontpageCurrencyService;
        this.bannersAddOperationFactory = bannersAddOperationFactory;
        this.textAddValidationService = textAddValidationService;
        this.cpmAddValidationService = cpmAddValidationService;
        this.contentPromotionAddValidationService = contentPromotionAddValidationService;
        this.mcBannerAddValidationService = mcBannerAddValidationService;
        this.mobileContentAddValidationService = mobileContentAddValidationService;
        this.performanceAddValidationService = performanceAddValidationService;
        this.priceBidModifierPlatformChooser = priceBidModifierPlatformChooser;
    }

    /**
     * @param showConditionAutoPrices      включает режим автоматического вычисления недостающих ставок в условиях
     *                                     показов
     * @param showConditionAutoPriceParams параметры для автоматического вычисления недостающих ставок в условиях
     *                                     показов. Должен быть не {@code null}, если
     *                                     {@code showConditionAutoPrices == true}
     */
    public ComplexTextAdGroupAddOperation createTextAdGroupAddOperation(
            boolean saveDraft,
            List<ComplexTextAdGroup> complexAdGroups,
            GeoTree geoTree,
            boolean showConditionAutoPrices,
            @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
            long operatorUid,
            ClientId clientId,
            long clientUid,
            DatabaseMode databaseMode) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexTextAdGroupAddOperation(saveDraft,
                clientService, adGroupService, keywordOperationFactory, bannersAddOperationFactory,
                vcardService, sitelinkSetService, relevanceMatchService, offerRetargetingService, retargetingService,
                bidModifierService, complexBidModifierService, textAddValidationService, campaignRepository,
                retargetingConditionOperationFactory,
                complexAdGroups, geoTree, showConditionAutoPrices, showConditionAutoPriceParams,
                operatorUid, clientId, clientUid, shard, databaseMode);
    }

    public ComplexCpmAdGroupAddOperation createCpmAdGroupAddOperation(
            boolean saveDraft,
            List<ComplexCpmAdGroup> complexAdGroups,
            GeoTree geoTree,
            boolean showConditionAutoPrices,
            @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
            long operatorUid,
            ClientId clientId,
            long clientUid,
            boolean refineGeo) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexCpmAdGroupAddOperation(saveDraft, cpmAddValidationService,
                usersSegmentService, adGroupService, cpmYndxFrontpageCurrencyService,
                retargetingService, bidModifierService, complexBidModifierService,
                campaignRepository, keywordOperationFactory, retargetingConditionOperationFactory,
                complexAdGroups, geoTree,
                showConditionAutoPrices, showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard,
                bannersAddOperationFactory, priceBidModifierPlatformChooser, shardHelper, refineGeo);
    }

    public ComplexContentPromotionAdGroupAddOperation createContentPromotionAdGroupAddOperation(
            boolean saveDraft,
            List<ComplexContentPromotionAdGroup> complexAdGroups,
            GeoTree geoTree,
            boolean showConditionAutoPrices,
            @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
            long operatorUid,
            ClientId clientId,
            long clientUid) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexContentPromotionAdGroupAddOperation(saveDraft,
                contentPromotionAddValidationService,
                clientService, campaignRepository, adGroupService, relevanceMatchService, bannersAddOperationFactory,
                bidModifierService, complexBidModifierService, keywordOperationFactory, complexAdGroups,
                geoTree, showConditionAutoPrices, showConditionAutoPriceParams, operatorUid,
                clientId, clientUid, shard);
    }

    public ComplexMcBannerAdGroupAddOperation createMcBannerAdGroupAddOperation(
            boolean saveDraft,
            List<ComplexMcBannerAdGroup> complexAdGroups,
            GeoTree geoTree,
            boolean showConditionAutoPrices,
            @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
            long operatorUid,
            ClientId clientId,
            long clientUid) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexMcBannerAdGroupAddOperation(saveDraft, adGroupService, keywordOperationFactory,
                bannersAddOperationFactory, vcardService, sitelinkSetService, bidModifierService,
                complexBidModifierService, mcBannerAddValidationService, campaignRepository, complexAdGroups, geoTree,
                showConditionAutoPrices, showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard);
    }

    public ComplexMobileContentAdGroupAddOperation createMobileContentAdGroupAddOperation(
            boolean saveDraft,
            List<ComplexMobileContentAdGroup> complexAdGroups,
            GeoTree geoTree,
            boolean showConditionAutoPrices,
            @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
            long operatorUid,
            ClientId clientId,
            long clientUid) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexMobileContentAdGroupAddOperation(saveDraft, clientService, adGroupService,
                keywordOperationFactory, bannersAddOperationFactory, vcardService, sitelinkSetService,
                relevanceMatchService, retargetingService, bidModifierService, complexBidModifierService,
                mobileContentAddValidationService, campaignRepository, complexAdGroups, geoTree,
                showConditionAutoPrices, showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard);
    }

    public ComplexDynamicAdGroupAddOperation createDynamicAdGroupAddOperation(
            boolean saveDraft,
            List<ComplexDynamicAdGroup> complexAdGroups,
            GeoTree geoTree,
            long operatorUid,
            ClientId clientId) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexDynamicAdGroupAddOperation(saveDraft, adGroupService, bidModifierService,
                complexBidModifierService, campaignRepository, complexAdGroups, geoTree, operatorUid, clientId, shard,
                bannersAddOperationFactory);
    }

    public ComplexPerformanceAdGroupAddOperation createPerformanceAdGroupAddOperation(
            Applicability applicability,
            boolean saveDraft,
            List<ComplexPerformanceAdGroup> complexAdGroups,
            GeoTree geoTree,
            long operatorUid,
            ClientId clientId) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexPerformanceAdGroupAddOperation(applicability, saveDraft, adGroupService, bidModifierService,
                complexBidModifierService, campaignRepository, complexAdGroups, geoTree, operatorUid, clientId, shard,
                performanceAddValidationService, bannersAddOperationFactory);
    }
}
