package ru.yandex.direct.core.entity.adgroup.service.complex;

import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.adgroup.container.ComplexContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexCpmAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexDynamicAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexMcBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexMobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexPerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexTextAdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;
import ru.yandex.direct.core.entity.adgroup.service.complex.contentpromotion.ComplexContentPromotionAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.contentpromotion.UpdateComplexContentPromotionAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.cpm.ComplexCpmAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.cpm.PriceBidModifierPlatformChooser;
import ru.yandex.direct.core.entity.adgroup.service.complex.cpm.UpdateComplexCpmAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.dynamic.ComplexDynamicAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.dynamic.UpdateComplexDynamicAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.mcbanner.ComplexMcBannerAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.mcbanner.UpdateComplexMcBannerAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.mobilecontent.ComplexMobileContentAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.mobilecontent.UpdateComplexMobileContentAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.performance.ComplexPerformanceAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.performance.UpdateComplexPerformanceAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.text.ComplexTextAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.text.RestrictedTextAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.text.UpdateComplexTextAdGroupValidationService;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.currency.service.CpmYndxFrontpageCurrencyService;
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository;
import ru.yandex.direct.core.entity.keyword.service.KeywordModifyOperationFactory;
import ru.yandex.direct.core.entity.offerretargeting.repository.OfferRetargetingRepository;
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingService;
import ru.yandex.direct.core.entity.relevancematch.repository.RelevanceMatchRepository;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.userssegments.service.UsersSegmentService;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;

@Component
@ParametersAreNonnullByDefault
public class ComplexAdGroupUpdateOperationFactory {

    private final ShardHelper shardHelper;
    private final UpdateComplexAdGroupValidationService updateComplexAdGroupValidationService;
    private final AdGroupService adGroupService;
    private final CpmYndxFrontpageCurrencyService cpmYndxFrontpageCurrencyService;
    private final KeywordModifyOperationFactory keywordModifyOperationFactory;
    private final RetargetingConditionOperationFactory retargetingConditionOperationFactory;
    private final RelevanceMatchService relevanceMatchService;
    private final OfferRetargetingService offerRetargetingService;
    private final RetargetingService retargetingService;
    private final BidModifierService bidModifierService;
    private final ComplexBidModifierService complexBidModifierService;
    private final BannersAddOperationFactory bannersAddOperationFactory;
    private final BannersUpdateOperationFactory bannersUpdateOperationFactory;
    private final VcardService vcardService;
    private final SitelinkSetService sitelinkSetService;
    private final CampaignRepository campaignRepository;
    private final AdGroupRepository adGroupRepository;
    private final KeywordRepository keywordRepository;
    private final UsersSegmentService usersSegmentService;
    private final RelevanceMatchRepository relevanceMatchRepository;
    private final OfferRetargetingRepository offerRetargetingRepository;
    private final UpdateComplexTextAdGroupValidationService textUpdateValidationService;
    private final UpdateComplexCpmAdGroupValidationService cpmUpdateValidationService;
    private final UpdateComplexContentPromotionAdGroupValidationService contentPromotionUpdateValidationService;
    private final UpdateComplexMcBannerAdGroupValidationService mcBannerUpdateValidationService;
    private final UpdateComplexMobileContentAdGroupValidationService mobileContentUpdateValidationService;
    private final PriceBidModifierPlatformChooser priceBidModifierPlatformChooser;
    private final UpdateComplexDynamicAdGroupValidationService dynamicUpdateValidationService;
    private final UpdateComplexPerformanceAdGroupValidationService performanceUpdateValidationService;

    public ComplexAdGroupUpdateOperationFactory(
            ShardHelper shardHelper,
            UpdateComplexAdGroupValidationService updateComplexAdGroupValidationService,
            AdGroupService adGroupService,
            CpmYndxFrontpageCurrencyService cpmYndxFrontpageCurrencyService,
            KeywordModifyOperationFactory keywordModifyOperationFactory,
            RetargetingConditionOperationFactory retargetingConditionOperationFactory,
            RelevanceMatchService relevanceMatchService,
            OfferRetargetingService offerRetargetingService,
            RetargetingService retargetingService,
            BidModifierService bidModifierService,
            ComplexBidModifierService complexBidModifierService,
            BannersAddOperationFactory bannersAddOperationFactory,
            BannersUpdateOperationFactory bannersUpdateOperationFactory,
            VcardService vcardService,
            SitelinkSetService sitelinkSetService,
            CampaignRepository campaignRepository,
            AdGroupRepository adGroupRepository,
            KeywordRepository keywordRepository,
            UsersSegmentService usersSegmentService,
            RelevanceMatchRepository relevanceMatchRepository,
            OfferRetargetingRepository offerRetargetingRepository,
            UpdateComplexTextAdGroupValidationService textUpdateValidationService,
            UpdateComplexCpmAdGroupValidationService cpmUpdateValidationService,
            UpdateComplexContentPromotionAdGroupValidationService contentPromotionUpdateValidationService,
            UpdateComplexMcBannerAdGroupValidationService mcBannerUpdateValidationService,
            UpdateComplexMobileContentAdGroupValidationService mobileContentUpdateValidationService,
            PriceBidModifierPlatformChooser priceBidModifierPlatformChooser,
            UpdateComplexDynamicAdGroupValidationService dynamicUpdateValidationService,
            UpdateComplexPerformanceAdGroupValidationService performanceUpdateValidationService) {
        this.shardHelper = shardHelper;
        this.updateComplexAdGroupValidationService = updateComplexAdGroupValidationService;
        this.adGroupService = adGroupService;
        this.cpmYndxFrontpageCurrencyService = cpmYndxFrontpageCurrencyService;
        this.keywordModifyOperationFactory = keywordModifyOperationFactory;
        this.retargetingConditionOperationFactory = retargetingConditionOperationFactory;
        this.relevanceMatchService = relevanceMatchService;
        this.offerRetargetingService = offerRetargetingService;
        this.retargetingService = retargetingService;
        this.bidModifierService = bidModifierService;
        this.complexBidModifierService = complexBidModifierService;
        this.bannersAddOperationFactory = bannersAddOperationFactory;
        this.bannersUpdateOperationFactory = bannersUpdateOperationFactory;
        this.vcardService = vcardService;
        this.sitelinkSetService = sitelinkSetService;
        this.campaignRepository = campaignRepository;
        this.adGroupRepository = adGroupRepository;
        this.keywordRepository = keywordRepository;
        this.usersSegmentService = usersSegmentService;
        this.relevanceMatchRepository = relevanceMatchRepository;
        this.offerRetargetingRepository = offerRetargetingRepository;
        this.textUpdateValidationService = textUpdateValidationService;
        this.cpmUpdateValidationService = cpmUpdateValidationService;
        this.contentPromotionUpdateValidationService = contentPromotionUpdateValidationService;
        this.mcBannerUpdateValidationService = mcBannerUpdateValidationService;
        this.mobileContentUpdateValidationService = mobileContentUpdateValidationService;
        this.priceBidModifierPlatformChooser = priceBidModifierPlatformChooser;
        this.dynamicUpdateValidationService = dynamicUpdateValidationService;
        this.performanceUpdateValidationService = performanceUpdateValidationService;
    }

    /**
     * @param showConditionAutoPrices      включает режим вычисления недостающих ставок в условиях показов
     * @param showConditionAutoPriceParams параметры для вычисления недостающих ставок в условиях показов.
     *                                     Должен быть не {@code null}, если {@code showConditionAutoPrices == true}
     */
    public ComplexTextAdGroupUpdateOperation createTextAdGroupUpdateOperation(List<ComplexTextAdGroup> complexAdGroups,
                                                                              GeoTree geoTree,
                                                                              boolean showConditionAutoPrices,
                                                                              @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                                                              boolean ucCustomAudienceEnabled,
                                                                              long operatorUid, ClientId clientId,
                                                                              long clientUid, boolean saveDraft) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexTextAdGroupUpdateOperation(saveDraft, updateComplexAdGroupValidationService, adGroupService,
                textUpdateValidationService, keywordModifyOperationFactory, relevanceMatchService,
                offerRetargetingService, retargetingService, bidModifierService, complexBidModifierService,
                bannersAddOperationFactory, bannersUpdateOperationFactory, retargetingConditionOperationFactory,
                vcardService, sitelinkSetService,
                campaignRepository, adGroupRepository, keywordRepository, relevanceMatchRepository,
                offerRetargetingRepository, complexAdGroups, geoTree, showConditionAutoPrices, ucCustomAudienceEnabled,
                showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard);
    }

    public RestrictedTextAdGroupUpdateOperation createRestrictedTextAdGroupUpdateOperation(
            List<ComplexTextAdGroup> complexAdGroups,
            GeoTree geoTree,
            boolean showConditionAutoPrices, @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
            long operatorUid, ClientId clientId, long clientUid, boolean saveDraft,
            Set<ModelProperty> availableProperties) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new RestrictedTextAdGroupUpdateOperation(saveDraft, adGroupService,
                textUpdateValidationService, keywordModifyOperationFactory, relevanceMatchService,
                offerRetargetingService, retargetingService, bidModifierService, complexBidModifierService,
                bannersAddOperationFactory, bannersUpdateOperationFactory, vcardService, sitelinkSetService,
                campaignRepository, adGroupRepository, keywordRepository, relevanceMatchRepository,
                offerRetargetingRepository, complexAdGroups, geoTree, showConditionAutoPrices,
                showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard, availableProperties,
                retargetingConditionOperationFactory);
    }

    public ComplexPerformanceAdGroupUpdateOperation createComplexPerformanceAdGroupUpdateOperation(
            Applicability applicability, List<ComplexPerformanceAdGroup> complexAdGroups, GeoTree geoTree,
            boolean useBidModifiers, long operatorUid, ClientId clientId, ModerationMode moderationMode) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexPerformanceAdGroupUpdateOperation(applicability, moderationMode, adGroupService,
                performanceUpdateValidationService, bannersAddOperationFactory, bannersUpdateOperationFactory,
                bidModifierService, complexBidModifierService, campaignRepository, complexAdGroups, geoTree,
                useBidModifiers, operatorUid, clientId, shard);
    }

    public ComplexDynamicAdGroupUpdateOperation createDynamicAdGroupUpdateOperation(
            List<ComplexDynamicAdGroup> complexAdGroups, GeoTree geoTree,
            long operatorUid, ClientId clientId, boolean saveDraft) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexDynamicAdGroupUpdateOperation(saveDraft, adGroupService, dynamicUpdateValidationService,
                adGroupRepository, bidModifierService, complexBidModifierService, campaignRepository, complexAdGroups,
                geoTree, operatorUid, clientId, shard);
    }

    public ComplexCpmAdGroupUpdateOperation createCpmAdGroupUpdateOperation(
            List<ComplexCpmAdGroup> complexAdGroups, GeoTree geoTree,
            boolean showConditionAutoPrices, @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
            long operatorUid, ClientId clientId, long clientUid, boolean saveDraft) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexCpmAdGroupUpdateOperation(saveDraft, complexAdGroups,
                adGroupService, adGroupRepository, cpmYndxFrontpageCurrencyService, cpmUpdateValidationService,
                bannersAddOperationFactory, bannersUpdateOperationFactory, bidModifierService,
                complexBidModifierService, campaignRepository, keywordModifyOperationFactory, keywordRepository,
                usersSegmentService, retargetingService,
                retargetingConditionOperationFactory,
                showConditionAutoPrices,
                showConditionAutoPriceParams, geoTree, operatorUid, clientId, clientUid, shard,
                priceBidModifierPlatformChooser, shardHelper);
    }

    public ComplexContentPromotionAdGroupUpdateOperation createContentPromotionAdGroupUpdateOperation(
            List<ComplexContentPromotionAdGroup> complexAdGroups, GeoTree geoTree,
            boolean showConditionAutoPrices, @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
            long operatorUid, ClientId clientId, long clientUid, boolean saveDraft) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexContentPromotionAdGroupUpdateOperation(saveDraft, updateComplexAdGroupValidationService,
                contentPromotionUpdateValidationService, campaignRepository, adGroupService, adGroupRepository,
                keywordModifyOperationFactory, keywordRepository, relevanceMatchService, relevanceMatchRepository,
                bidModifierService, complexBidModifierService, bannersAddOperationFactory,
                bannersUpdateOperationFactory, geoTree, complexAdGroups, showConditionAutoPrices,
                showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard);
    }

    /**
     * @param showConditionAutoPrices      включает режим вычисления недостающих ставок в условиях показов
     * @param showConditionAutoPriceParams параметры для вычисления недостающих ставок в условиях показов.
     *                                     Должен быть не {@code null}, если {@code showConditionAutoPrices == true}
     */
    public ComplexMcBannerAdGroupUpdateOperation createMcBannerAdGroupUpdateOperation(List<ComplexMcBannerAdGroup> complexAdGroups,
                                                                                      GeoTree geoTree,
                                                                                      boolean showConditionAutoPrices,
                                                                                      @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                                                                      long operatorUid,
                                                                                      ClientId clientId,
                                                                                      long clientUid,
                                                                                      boolean saveDraft) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexMcBannerAdGroupUpdateOperation(saveDraft,
                adGroupService,
                mcBannerUpdateValidationService, keywordModifyOperationFactory,
                bidModifierService, complexBidModifierService, bannersAddOperationFactory,
                bannersUpdateOperationFactory, vcardService, sitelinkSetService, campaignRepository,
                adGroupRepository, keywordRepository,
                complexAdGroups, geoTree, showConditionAutoPrices, showConditionAutoPriceParams,
                operatorUid, clientId, clientUid, shard);
    }

    /**
     * @param showConditionAutoPrices      включает режим вычисления недостающих ставок в условиях показов
     * @param showConditionAutoPriceParams параметры для вычисления недостающих ставок в условиях показов.
     *                                     Должен быть не {@code null}, если {@code showConditionAutoPrices == true}
     */
    public ComplexMobileContentAdGroupUpdateOperation createMobileContentAdGroupUpdateOperation(List<ComplexMobileContentAdGroup> complexAdGroups,
                                                                                                GeoTree geoTree,
                                                                                                boolean showConditionAutoPrices,
                                                                                                @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                                                                                long operatorUid,
                                                                                                ClientId clientId,
                                                                                                long clientUid,
                                                                                                boolean saveDraft) {
        int shard = shardHelper.getShardByClientIdStrictly(clientId);
        return new ComplexMobileContentAdGroupUpdateOperation(saveDraft, adGroupService,
                mobileContentUpdateValidationService, keywordModifyOperationFactory, relevanceMatchService,
                retargetingService, bidModifierService, complexBidModifierService, bannersAddOperationFactory,
                bannersUpdateOperationFactory, vcardService, sitelinkSetService, campaignRepository,
                adGroupRepository, keywordRepository, relevanceMatchRepository, complexAdGroups, geoTree,
                showConditionAutoPrices, showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard);
    }
}
