package ru.yandex.direct.core.entity.adgroup.service.complex.contentpromotion;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.container.ComplexContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.service.complex.AddComplexAdGroupValidationService;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupValidationCommons.adGroupTypeIsApplicable;

@Service
@ParametersAreNonnullByDefault
public class AddComplexContentPromotionAdGroupValidationService {
    private static final Set<AdGroupType> APPLICABLE_TYPES = ImmutableSet.of(AdGroupType.CONTENT_PROMOTION_VIDEO,
            AdGroupType.CONTENT_PROMOTION);

    private final AddComplexAdGroupValidationService addValidationService;
    @Autowired
    public AddComplexContentPromotionAdGroupValidationService(AddComplexAdGroupValidationService addValidationService) {
        this.addValidationService = addValidationService;
    }

    public ValidationResult<List<AdGroup>, Defect> validateAdGroups(
            ValidationResult<List<AdGroup>, Defect> adGroupsResult,
            List<ComplexContentPromotionAdGroup> complexAdGroups) {
        return new ListValidationBuilder<>(adGroupsResult)
                .checkEachBy((index, adGroup) -> {
                    ComplexContentPromotionAdGroup complexAdGroup = complexAdGroups.get(index);
                    return validateAdGroup(complexAdGroup);
                }).getResult();
    }

    private ValidationResult<AdGroup, Defect> validateAdGroup(ComplexContentPromotionAdGroup complexAdGroup) {
        ModelItemValidationBuilder<AdGroup> vb = ModelItemValidationBuilder.of(complexAdGroup.getAdGroup());

        vb.item(AdGroup.TYPE)
                .check(adGroupTypeIsApplicable(APPLICABLE_TYPES));

        vb.list(complexAdGroup.getBanners(), ComplexContentPromotionAdGroup.BANNERS.name())
                .checkBy(banners -> addValidationService.validateBanners(complexAdGroup.getAdGroup(), banners));

        return vb.getResult();
    }
}
