package ru.yandex.direct.core.entity.adgroup.service.complex.contentpromotion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.container.ComplexContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.BannerLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.BidModifiersLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.KeywordLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.RelevanceMatchLogicSupplier;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.keyword.service.KeywordOperationFactory;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public class ComplexContentPromotionAdGroupAddOperation extends
        ComplexAdGroupAddOperation<ComplexContentPromotionAdGroup> {

    private AddComplexContentPromotionAdGroupValidationService addValidationService;

    private BannerLogicSupplier<ComplexContentPromotionAdGroup, BannerWithSystemFields> bannersLogicSupplier;
    private KeywordLogicSupplier<ComplexContentPromotionAdGroup> keywordLogicSupplier;
    private RelevanceMatchLogicSupplier<ComplexContentPromotionAdGroup> relevanceMatchLogicSupplier;
    private BidModifiersLogicSupplier<ComplexContentPromotionAdGroup> bidModifiersLogicSupplier;

    public ComplexContentPromotionAdGroupAddOperation(boolean saveDraft,
                                                      AddComplexContentPromotionAdGroupValidationService
                                                              addValidationService,
                                                      ClientService clientService, CampaignRepository
                                                              campaignRepository, AdGroupService adGroupService,
                                                      RelevanceMatchService relevanceMatchService,
                                                      BannersAddOperationFactory bannersAddOperationFactory,
                                                      BidModifierService bidModifierService,
                                                      ComplexBidModifierService complexBidModifierService,
                                                      KeywordOperationFactory keywordOperationFactory,
                                                      List<ComplexContentPromotionAdGroup> complexAdGroups,
                                                      GeoTree geoTree, boolean showConditionAutoPrices,
                                                      @Nullable ShowConditionAutoPriceParams
                                                              showConditionAutoPriceParams, long operatorUid,
                                                      ClientId clientId, long clientUid, int shard) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId, true);
        this.addValidationService = addValidationService;

        ShowConditionFixedAutoPrices showConditionFixedAutoPrices = null;
        if (showConditionAutoPrices) {
            checkArgument(showConditionAutoPriceParams != null,
                    "showConditionAutoPriceParams must be specified in showConditionAutoPrices mode");
            showConditionFixedAutoPrices = showConditionAutoPriceParams.getFixedAutoPrices();
        }

        Currency clientCurrency = clientService.getWorkCurrency(clientId);

        bannersLogicSupplier = new BannerLogicSupplier<>(complexAdGroups, ComplexContentPromotionAdGroup.BANNERS,
                bannersAddOperationFactory, operatorUid, clientId, saveDraft);
        keywordLogicSupplier = new KeywordLogicSupplier<>(complexAdGroups, ComplexContentPromotionAdGroup.KEYWORDS,
                keywordOperationFactory, showConditionAutoPrices, showConditionFixedAutoPrices,
                operatorUid, clientId, clientUid);
        relevanceMatchLogicSupplier = new RelevanceMatchLogicSupplier<>(complexAdGroups,
                ComplexContentPromotionAdGroup.RELEVANCE_MATCHES,
                campaignRepository, relevanceMatchService, clientCurrency,
                showConditionAutoPrices, showConditionAutoPriceParams, operatorUid, clientId, shard);
        bidModifiersLogicSupplier =
                new BidModifiersLogicSupplier<>(complexAdGroups,
                        ComplexContentPromotionAdGroup.COMPLEX_BID_MODIFIER,
                        campaignRepository, bidModifierService, complexBidModifierService, operatorUid, clientId,
                        shard);
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);

        keywordLogicSupplier.prepare(adGroupsResult);

        passBannerValidationInfo();
        bannersLogicSupplier.prepare(adGroupsResult);

        relevanceMatchLogicSupplier.prepare(adGroupsResult);
        bidModifiersLogicSupplier.prepare(adGroupsResult);
    }

    /**
     * Прокидывание информации, необходимой для валидации баннера
     */
    private void passBannerValidationInfo() {
        Map<Integer, ContentPromotionAdgroupType> bannerValidationInfoMap = new HashMap<>();
        bannersLogicSupplier.getBannerExecutor().getIndexMultimap().forEach((adGroupIndex, bannerFlatIndex) -> {
            ComplexContentPromotionAdGroup complexAdGroup = complexAdGroups.get(adGroupIndex);
            if (complexAdGroup.getAdGroup().getType() == AdGroupType.CONTENT_PROMOTION) {
                bannerValidationInfoMap.put(bannerFlatIndex,
                        ((ContentPromotionAdGroup) complexAdGroup.getAdGroup()).getContentPromotionType());
            } else {
                bannerValidationInfoMap.put(bannerFlatIndex, ContentPromotionAdgroupType.VIDEO);
            }
        });
        bannersLogicSupplier.getBannerExecutor().getSubOperation()
                .setContentPromotionBannerValidationInfo(bannerValidationInfoMap);
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult =
                addValidationService.validateAdGroups(adGroupsResult, complexAdGroups);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "AddComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> addAdGroupsResult) {
        bannersLogicSupplier.apply(addAdGroupsResult);
        // Применение ключевых фраз должно осуществляться только после применения баннеров,
        // так как внутри осуществляется извлечение из базы баннеров для похода в торги.
        keywordLogicSupplier.apply(addAdGroupsResult);
        relevanceMatchLogicSupplier.apply(addAdGroupsResult);
        bidModifiersLogicSupplier.apply(addAdGroupsResult);
    }
}
