package ru.yandex.direct.core.entity.adgroup.service.complex.contentpromotion;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.container.ComplexContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.UpdateComplexAdGroupValidationService;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BannerLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BidModifierLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.KeywordLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.RelevanceMatchLogicSupplier;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository;
import ru.yandex.direct.core.entity.keyword.service.KeywordModifyOperationFactory;
import ru.yandex.direct.core.entity.relevancematch.repository.RelevanceMatchRepository;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public class ComplexContentPromotionAdGroupUpdateOperation extends ComplexAdGroupUpdateOperation<ComplexContentPromotionAdGroup> {

    private final UpdateComplexContentPromotionAdGroupValidationService updateValidationService;
    private final ClientId clientId;

    private BannerLogicSupplier<ComplexContentPromotionAdGroup, BannerWithSystemFields> bannerLogicSupplier;
    private KeywordLogicSupplier<ComplexContentPromotionAdGroup> keywordLogicSupplier;
    private RelevanceMatchLogicSupplier<ComplexContentPromotionAdGroup> relevanceMatchLogicSupplier;
    private BidModifierLogicSupplier<ComplexContentPromotionAdGroup> bidModifierLogicSupplier;

    public ComplexContentPromotionAdGroupUpdateOperation(boolean saveDraft,
                                                         UpdateComplexAdGroupValidationService complexValidationService,
                                                         UpdateComplexContentPromotionAdGroupValidationService updateValidationService,
                                                         CampaignRepository campaignRepository,
                                                         AdGroupService adGroupService,
                                                         AdGroupRepository adGroupRepository,
                                                         KeywordModifyOperationFactory keywordModifyOperationFactory,
                                                         KeywordRepository keywordRepository,
                                                         RelevanceMatchService relevanceMatchService,
                                                         RelevanceMatchRepository relevanceMatchRepository,
                                                         BidModifierService bidModifierService,
                                                         ComplexBidModifierService complexBidModifierService,
                                                         BannersAddOperationFactory bannersAddOperationFactory,
                                                         BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                                         GeoTree geoTree,
                                                         List<ComplexContentPromotionAdGroup> complexAdGroups,
                                                         boolean showConditionAutoPrices,
                                                         @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                                         long operatorUid, ClientId clientId, long clientUid, int shard) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId);
        this.updateValidationService = updateValidationService;
        this.clientId = clientId;

        Set<Long> affectedAdGroupIds = adGroupSimpleMap.keySet();

        bannerLogicSupplier =
                new BannerLogicSupplier<>(complexAdGroups, ComplexContentPromotionAdGroup.BANNERS,
                        bannersAddOperationFactory, bannersUpdateOperationFactory,
                        operatorUid, clientId, bannersModerationMode);
        keywordLogicSupplier = new KeywordLogicSupplier<>(complexAdGroups, ComplexContentPromotionAdGroup.KEYWORDS,
                affectedAdGroupIds, keywordModifyOperationFactory, keywordRepository, showConditionAutoPrices,
                showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard);
        relevanceMatchLogicSupplier = new RelevanceMatchLogicSupplier<>(complexAdGroups,
                ComplexContentPromotionAdGroup.RELEVANCE_MATCHES, affectedAdGroupIds, relevanceMatchService,
                relevanceMatchRepository, showConditionAutoPrices, showConditionAutoPriceParams, operatorUid,
                clientId, clientUid, shard);
        bidModifierLogicSupplier =
                new BidModifierLogicSupplier<>(complexAdGroups, ComplexContentPromotionAdGroup.COMPLEX_BID_MODIFIER,
                        affectedAdGroupIds, bidModifierService, complexBidModifierService, campaignRepository,
                        operatorUid, clientId, shard);
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);

        keywordLogicSupplier.prepare(adGroupsResult);
        relevanceMatchLogicSupplier.prepare(adGroupsResult);
        bidModifierLogicSupplier.prepare(adGroupsResult);

        passBannerValidationInfo();
        bannerLogicSupplier.prepare(adGroupsResult);
    }

    /**
     * Прокидывание информации, необходимой для валидации баннера
     */
    private void passBannerValidationInfo() {
        Map<Integer, ContentPromotionAdgroupType> bannerValidationInfoMap = new HashMap<>();
        bannerLogicSupplier.getBannerExecutor().getIndexMultimap().forEach((adGroupIndex, bannerFlatIndex) -> {
            ComplexContentPromotionAdGroup complexAdGroup = complexAdGroups.get(adGroupIndex);
            if(complexAdGroup.getAdGroup().getType() == AdGroupType.CONTENT_PROMOTION) {
                bannerValidationInfoMap.put(bannerFlatIndex,
                        ((ContentPromotionAdGroup)complexAdGroup.getAdGroup()).getContentPromotionType());
            } else {
                bannerValidationInfoMap.put(bannerFlatIndex, ContentPromotionAdgroupType.VIDEO);
            }
        });

        bannerLogicSupplier.getBannerExecutor().getSubOperation()
                .setContentPromotionBannerValidationInfo(bannerValidationInfoMap);
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult = updateValidationService
                .validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "ComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> updateAdGroupsResult) {
        bannerLogicSupplier.apply(updateAdGroupsResult);
        // Применение ключевых фраз должно осуществляться только после применения баннеров,
        // так как внутри осуществляется извлечение из базы баннеров для похода в торги.
        // Потенциальная точка рефакторинга.
        keywordLogicSupplier.apply(updateAdGroupsResult);
        relevanceMatchLogicSupplier.apply(updateAdGroupsResult);
        bidModifierLogicSupplier.apply(updateAdGroupsResult);
    }
}
