package ru.yandex.direct.core.entity.adgroup.service.complex.cpm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexCpmAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.BannerLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.BidModifiersLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.CpmUsersSegmentsLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.KeywordLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.RetargetingConditionLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.RetargetingLogicSupplier;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.validation.BannerValidationInfo;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.CpmYndxFrontpageAdGroupPriceRestrictions;
import ru.yandex.direct.core.entity.currency.service.CpmYndxFrontpageCurrencyService;
import ru.yandex.direct.core.entity.keyword.service.KeywordOperationFactory;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.core.entity.userssegments.service.UsersSegmentService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;


public class ComplexCpmAdGroupAddOperation extends ComplexAdGroupAddOperation<ComplexCpmAdGroup> {

    private AddComplexCpmAdGroupValidationService addValidationService;

    private BannerLogicSupplier<ComplexCpmAdGroup, BannerWithSystemFields> bannersLogicSupplier;
    private KeywordLogicSupplier<ComplexCpmAdGroup> keywordLogicSupplier;
    private RetargetingConditionLogicSupplier<ComplexCpmAdGroup> retargetingConditionLogicSupplier;
    private RetargetingLogicSupplier<ComplexCpmAdGroup> retargetingLogicSupplier;
    private BidModifiersLogicSupplier<ComplexCpmAdGroup> bidModifiersLogicSupplier;
    private CpmUsersSegmentsLogicSupplier cpmUsersSegmentsLogicSupplier;
    private final PriceBidModifierPlatformChooser priceBidModifierPlatformChooser;
    private final ShardHelper shardHelper;

    public ComplexCpmAdGroupAddOperation(boolean saveDraft,
                                         AddComplexCpmAdGroupValidationService addValidationService,
                                         UsersSegmentService usersSegmentService,
                                         AdGroupService adGroupService,
                                         CpmYndxFrontpageCurrencyService cpmYndxFrontpageCurrencyService,
                                         RetargetingService retargetingService, BidModifierService bidModifierService,
                                         ComplexBidModifierService complexBidModifierService,
                                         CampaignRepository campaignRepository,
                                         KeywordOperationFactory keywordOperationFactory,
                                         RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                         List<ComplexCpmAdGroup> complexAdGroups, GeoTree geoTree,
                                         boolean showConditionAutoPrices,
                                         @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                         long operatorUid,
                                         ClientId clientId, long clientUid, int shard,
                                         BannersAddOperationFactory bannersAddOperationFactory,
                                         PriceBidModifierPlatformChooser priceBidModifierPlatformChooser,
                                         ShardHelper shardHelper,
                                         boolean refineGeo) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId, refineGeo);
        this.addValidationService = addValidationService;
        this.priceBidModifierPlatformChooser = priceBidModifierPlatformChooser;
        this.shardHelper = shardHelper;

        ShowConditionFixedAutoPrices showConditionFixedAutoPrices = null;
        if (showConditionAutoPrices) {
            checkArgument(showConditionAutoPriceParams != null,
                    "showConditionAutoPriceParams must be specified in showConditionAutoPrices mode");
            showConditionFixedAutoPrices = showConditionAutoPriceParams.getFixedAutoPrices();
        }

        Map<Integer, CpmYndxFrontpageAdGroupPriceRestrictions> frontpageAdGroupsPriceRestrictions =
                cpmYndxFrontpageCurrencyService.getAdGroupIndexesToPriceDataMapByAdGroups(
                        mapList(complexAdGroups, ComplexAdGroup::getAdGroup), shard, clientId);

        bannersLogicSupplier = new BannerLogicSupplier<>(complexAdGroups, ComplexCpmAdGroup.BANNERS,
                bannersAddOperationFactory, operatorUid, clientId, saveDraft);
        keywordLogicSupplier = new KeywordLogicSupplier<>(complexAdGroups, ComplexCpmAdGroup.KEYWORDS,
                keywordOperationFactory, showConditionAutoPrices, showConditionFixedAutoPrices,
                operatorUid, clientId, clientUid);
        retargetingConditionLogicSupplier =
                new RetargetingConditionLogicSupplier<>(complexAdGroups, ComplexCpmAdGroup.RETARGETING_CONDITIONS,
                        retargetingConditionOperationFactory, clientId);
        retargetingLogicSupplier = new RetargetingLogicSupplier<>(complexAdGroups, frontpageAdGroupsPriceRestrictions,
                ComplexCpmAdGroup.TARGET_INTERESTS, retargetingService, campaignRepository, true,
                showConditionAutoPrices, showConditionFixedAutoPrices, operatorUid, clientId, clientUid, shard);
        bidModifiersLogicSupplier =
                new BidModifiersLogicSupplier<>(complexAdGroups, ComplexCpmAdGroup.COMPLEX_BID_MODIFIER,
                        campaignRepository, bidModifierService, complexBidModifierService, operatorUid, clientId,
                        shard);
        cpmUsersSegmentsLogicSupplier = new CpmUsersSegmentsLogicSupplier(complexAdGroups, usersSegmentService, shard);
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {

        validateInterconnections(adGroupsResult);
        keywordLogicSupplier.prepare(adGroupsResult);
        retargetingConditionLogicSupplier.prepare(adGroupsResult);

        passRetargetingConditions();
        retargetingLogicSupplier.prepare(adGroupsResult);

        priceBidModifierPlatformChooser.addComplexModifiersForPriceAdGroups(shardHelper.getShardByClientId(clientId),
                complexAdGroups);
        bidModifiersLogicSupplier.prepare(adGroupsResult);
        cpmUsersSegmentsLogicSupplier.prepare(adGroupsResult);

        passBannerValidationInfo();
        bannersLogicSupplier.prepare(adGroupsResult);
    }

    private void passRetargetingConditions() {
        List<RetargetingConditionBase> retargetingConditions =
                retargetingConditionLogicSupplier.getRetargetingConditionsExecutor().getSubOperation()
                        .getRetargetingConditions();

        // set fake id
        for (int i = 0; i < retargetingConditions.size(); i++) {
            retargetingConditions.get(i).withId(((long) -(i + 1)));
        }

        retargetingLogicSupplier.getRetargetingExecutor().getSubOperation().setRetargetingConditions(
                mapList(retargetingConditions, rc -> (RetargetingCondition) rc));
    }

    /**
     * Прокидывание информации, необходимой для валидации баннера
     */
    private void passBannerValidationInfo() {
        Map<Integer, BannerValidationInfo> bannerValidationInfoMap = new HashMap<>();
        bannersLogicSupplier.getBannerExecutor().getIndexMultimap().forEach((adGroupIndex, bannerFlatIndex) -> {
            ComplexCpmAdGroup complexCpmAdGroup = complexAdGroups.get(adGroupIndex);
            List<RetargetingCondition> retargetingConditions =
                    mapList(complexCpmAdGroup.getRetargetingConditions(), rc -> (RetargetingCondition) rc);
            bannerValidationInfoMap.put(bannerFlatIndex, new BannerValidationInfo(complexCpmAdGroup.getKeywords(),
                    null, complexCpmAdGroup.getAdGroup().getCampaignId(),
                    retargetingConditions, complexCpmAdGroup.getAdGroup().getType()));
        });

        bannersLogicSupplier.getBannerExecutor().getSubOperation().setBannerValidationInfo(bannerValidationInfoMap);
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {

        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult =
                addValidationService.validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "AddComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> addAdGroupsResult) {
        bannersLogicSupplier.apply(addAdGroupsResult);
        keywordLogicSupplier.apply(addAdGroupsResult);
        retargetingConditionLogicSupplier.apply(addAdGroupsResult);

        passRetargetingConditionIdsToRetargetings();
        retargetingLogicSupplier.apply(addAdGroupsResult);

        bidModifiersLogicSupplier.apply(addAdGroupsResult);
        cpmUsersSegmentsLogicSupplier.apply(addAdGroupsResult);
    }

    private void passRetargetingConditionIdsToRetargetings() {
        List<RetargetingConditionBase> retargetingConditions =
                retargetingConditionLogicSupplier.getRetargetingConditionsExecutor().getSubOperation()
                        .getRetargetingConditions();

        retargetingLogicSupplier.getRetargetingExecutor().getSubOperation().setRetargetingConditionsIds(
                mapList(retargetingConditions, rc -> (RetargetingCondition) rc));
    }
}
