package ru.yandex.direct.core.entity.adgroup.service.complex.cpm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.container.ComplexCpmAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BannerLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BidModifierLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.CpmUsersSegmentsLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.KeywordLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.RetargetingConditionLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.RetargetingLogicSupplier;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.banner.service.validation.BannerValidationInfo;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.currency.model.cpmyndxfrontpage.CpmYndxFrontpageAdGroupPriceRestrictions;
import ru.yandex.direct.core.entity.currency.service.CpmYndxFrontpageCurrencyService;
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository;
import ru.yandex.direct.core.entity.keyword.service.KeywordModifyOperationFactory;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.core.entity.userssegments.service.UsersSegmentService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class ComplexCpmAdGroupUpdateOperation extends ComplexAdGroupUpdateOperation<ComplexCpmAdGroup> {
    private final UpdateComplexCpmAdGroupValidationService updateValidationService;
    private final ClientId clientId;

    private BannerLogicSupplier<ComplexCpmAdGroup, BannerWithSystemFields> bannersLogicSupplier;
    private KeywordLogicSupplier<ComplexCpmAdGroup> keywordLogicSupplier;
    private RetargetingConditionLogicSupplier<ComplexCpmAdGroup> retargetingConditionLogicSupplier;
    private RetargetingLogicSupplier<ComplexCpmAdGroup> retargetingLogicSupplier;
    private BidModifierLogicSupplier<ComplexCpmAdGroup> bidModifiersLogicSupplier;
    private CpmUsersSegmentsLogicSupplier cpmUsersSegmentsLogicSupplier;
    private final PriceBidModifierPlatformChooser priceBidModifierPlatformChooser;
    private final ShardHelper shardHelper;

    public ComplexCpmAdGroupUpdateOperation(boolean saveDraft, List<ComplexCpmAdGroup> complexAdGroups,
                                            AdGroupService adGroupService, AdGroupRepository adGroupRepository,
                                            CpmYndxFrontpageCurrencyService cpmYndxFrontpageCurrencyService,
                                            UpdateComplexCpmAdGroupValidationService updateValidationService,
                                            BannersAddOperationFactory bannersAddOperationFactory,
                                            BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                            BidModifierService bidModifierService,
                                            ComplexBidModifierService complexBidModifierService,
                                            CampaignRepository campaignRepository,
                                            KeywordModifyOperationFactory keywordModifyOperationFactory,
                                            KeywordRepository keywordRepository,
                                            UsersSegmentService usersSegmentService,
                                            RetargetingService retargetingService,
                                            RetargetingConditionOperationFactory retargetingConditionOperationFactory,
                                            boolean showConditionAutoPrices,
                                            @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                            GeoTree geoTree, long operatorUid, ClientId clientId, long clientUid,
                                            int shard,
                                            PriceBidModifierPlatformChooser priceBidModifierPlatformChooser,
                                            ShardHelper shardHelper) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId);
        this.updateValidationService = updateValidationService;
        this.clientId = clientId;
        this.priceBidModifierPlatformChooser = priceBidModifierPlatformChooser;
        this.shardHelper = shardHelper;

        Set<Long> affectedAdGroupIds = adGroupSimpleMap.keySet();

        Map<Long, CpmYndxFrontpageAdGroupPriceRestrictions> affectedFrontpageAdGroupsPriceRestrictions =
                cpmYndxFrontpageCurrencyService.getAdGroupIdsToPriceDataMapByAdGroups(adGroups, shard, clientId);

        ShowConditionFixedAutoPrices showConditionFixedAutoPrices = null;
        if (showConditionAutoPrices) {
            checkArgument(showConditionAutoPriceParams != null,
                    "showConditionAutoPriceParams must be specified in showConditionAutoPrices mode");
            showConditionFixedAutoPrices = showConditionAutoPriceParams.getFixedAutoPrices();
        }

        bannersLogicSupplier = new BannerLogicSupplier<>(complexAdGroups, ComplexCpmAdGroup.BANNERS,
                bannersAddOperationFactory, bannersUpdateOperationFactory, operatorUid, clientId, bannersModerationMode);
        keywordLogicSupplier = new KeywordLogicSupplier<>(complexAdGroups, ComplexCpmAdGroup.KEYWORDS,
                affectedAdGroupIds, keywordModifyOperationFactory, keywordRepository, showConditionAutoPrices,
                showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard);
        retargetingConditionLogicSupplier =
                new RetargetingConditionLogicSupplier<>(complexAdGroups, ComplexCpmAdGroup.RETARGETING_CONDITIONS,
                        retargetingConditionOperationFactory, clientId);
        retargetingLogicSupplier = new RetargetingLogicSupplier<>(complexAdGroups, ComplexCpmAdGroup.TARGET_INTERESTS,
                retargetingService, adGroupSimpleMap, affectedFrontpageAdGroupsPriceRestrictions,
                showConditionAutoPrices, showConditionFixedAutoPrices, operatorUid, clientId, clientUid, shard);
        bidModifiersLogicSupplier =
                new BidModifierLogicSupplier<>(complexAdGroups, ComplexCpmAdGroup.COMPLEX_BID_MODIFIER,
                        affectedAdGroupIds, bidModifierService, complexBidModifierService, campaignRepository,
                        operatorUid, clientId, shard);
        cpmUsersSegmentsLogicSupplier =
                new CpmUsersSegmentsLogicSupplier(complexAdGroups, usersSegmentService, shard);
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);
        keywordLogicSupplier.prepare(adGroupsResult);
        retargetingConditionLogicSupplier.prepare(adGroupsResult);
        retargetingLogicSupplier.prepare(adGroupsResult);

        priceBidModifierPlatformChooser.addComplexModifiersForPriceAdGroups(shardHelper.getShardByClientId(clientId),
                complexAdGroups);
        bidModifiersLogicSupplier.prepare(adGroupsResult);
        cpmUsersSegmentsLogicSupplier.prepare(adGroupsResult);

        passBannerValidationInfo();
        bannersLogicSupplier.prepare(adGroupsResult);
    }

    /**
     * Прокидывание информации, необходимой для валидации баннера
     */
    private void passBannerValidationInfo() {
        Map<Integer, BannerValidationInfo> bannerValidationInfoMap = new HashMap<>();
        bannersLogicSupplier.getBannerExecutor().getIndexMultimap().forEach((adGroupIndex, bannerFlatIndex) -> {
            ComplexCpmAdGroup complexCpmAdGroup = complexAdGroups.get(adGroupIndex);
            List<RetargetingCondition> retargetingConditions =
                    mapList(complexCpmAdGroup.getRetargetingConditions(), rc -> (RetargetingCondition) rc);
            bannerValidationInfoMap.put(bannerFlatIndex, new BannerValidationInfo(complexCpmAdGroup.getKeywords(),
                    null, complexCpmAdGroup.getAdGroup().getCampaignId(),
                    retargetingConditions, complexCpmAdGroup.getAdGroup().getType()));
        });

        bannersLogicSupplier.getBannerExecutor().getSubOperation().setBannerValidationInfo(bannerValidationInfoMap);
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult = updateValidationService
                .validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "ComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> updateAdGroupsResult) {
        bannersLogicSupplier.apply(updateAdGroupsResult);
        keywordLogicSupplier.apply(updateAdGroupsResult);
        retargetingConditionLogicSupplier.apply(updateAdGroupsResult);
        retargetingLogicSupplier.apply(updateAdGroupsResult);
        bidModifiersLogicSupplier.apply(updateAdGroupsResult);
        cpmUsersSegmentsLogicSupplier.apply(updateAdGroupsResult);
    }
}
