package ru.yandex.direct.core.entity.adgroup.service.complex.dynamic;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.adgroup.container.ComplexDynamicAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BidModifierLogicSupplier;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkState;

public class ComplexDynamicAdGroupUpdateOperation extends ComplexAdGroupUpdateOperation<ComplexDynamicAdGroup> {

    private final UpdateComplexDynamicAdGroupValidationService updateValidationService;
    private final ClientId clientId;
    private BidModifierLogicSupplier<ComplexDynamicAdGroup> bidModifierLogicSupplier;

    public ComplexDynamicAdGroupUpdateOperation(boolean saveDraft,
                                                AdGroupService adGroupService,
                                                UpdateComplexDynamicAdGroupValidationService updateValidationService,
                                                AdGroupRepository adGroupRepository,
                                                BidModifierService bidModifierService,
                                                ComplexBidModifierService complexBidModifierService,
                                                CampaignRepository campaignRepository,
                                                List<ComplexDynamicAdGroup> complexAdGroups,
                                                GeoTree geoTree,
                                                long operatorUid,
                                                ClientId clientId,
                                                int shard) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId);
        this.updateValidationService = updateValidationService;
        this.clientId = clientId;

        Set<Long> affectedAdGroupIds = adGroupSimpleMap.keySet();

        bidModifierLogicSupplier =
                new BidModifierLogicSupplier<>(complexAdGroups, ComplexDynamicAdGroup.COMPLEX_BID_MODIFIER,
                        affectedAdGroupIds, bidModifierService, complexBidModifierService, campaignRepository,
                        operatorUid, clientId, shard);
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult =
                updateValidationService.validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "ComplexAdGroupValidationService must not return operational errors or warnings");
        bidModifierLogicSupplier.prepare(adGroupsResult);
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> updateAdGroupsResult) {
        bidModifierLogicSupplier.apply(updateAdGroupsResult);
    }
}
