package ru.yandex.direct.core.entity.adgroup.service.complex.internal;

import java.util.List;

import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.container.InternalAdGroupAddItem;
import ru.yandex.direct.core.entity.adgroup.container.InternalAdGroupOperationContainer;
import ru.yandex.direct.core.entity.adgroup.container.InternalAdGroupUpdateItem;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.AdGroupAdditionalTargetingGroupsUpdateOperationFactory;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.service.AdGroupAdditionalTargetingsAddOperationFactory;
import ru.yandex.direct.core.entity.client.service.ClientGeoService;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.core.entity.retargeting.repository.RetargetingRepository;
import ru.yandex.direct.core.entity.retargeting.service.AddTargetInterestService;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingDeleteService;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;

@Service
public class ComplexInternalAdGroupService {
    private final ShardHelper shardHelper;
    private final ClientGeoService clientGeoService;
    private final AdGroupService adGroupService;
    private final AdGroupAdditionalTargetingsAddOperationFactory adGroupAdditionalTargetingsAddOperationFactory;
    private final AdGroupAdditionalTargetingGroupsUpdateOperationFactory adGroupAdditionalTargetingGroupUpdateOperationFactory;
    private final RetargetingConditionOperationFactory retargetingConditionOperationFactory;
    private final ClientService clientService;
    private final AddTargetInterestService targetInterestService;
    private final RetargetingRepository retargetingRepository;
    private final RetargetingDeleteService retargetingDeleteService;

    public ComplexInternalAdGroupService(
            ShardHelper shardHelper, ClientGeoService clientGeoService,
            AdGroupService adGroupService,
            AdGroupAdditionalTargetingsAddOperationFactory adGroupAdditionalTargetingsAddOperationFactory,
            AdGroupAdditionalTargetingGroupsUpdateOperationFactory adGroupAdditionalTargetingGroupUpdateOperationFactory,
            RetargetingConditionOperationFactory retargetingConditionOperationFactory,
            ClientService clientService, AddTargetInterestService targetInterestService,
            RetargetingRepository retargetingRepository, RetargetingDeleteService retargetingDeleteService) {
        this.shardHelper = shardHelper;
        this.clientGeoService = clientGeoService;
        this.adGroupService = adGroupService;
        this.adGroupAdditionalTargetingsAddOperationFactory = adGroupAdditionalTargetingsAddOperationFactory;
        this.adGroupAdditionalTargetingGroupUpdateOperationFactory =
                adGroupAdditionalTargetingGroupUpdateOperationFactory;
        this.retargetingConditionOperationFactory = retargetingConditionOperationFactory;
        this.clientService = clientService;
        this.targetInterestService = targetInterestService;
        this.retargetingRepository = retargetingRepository;
        this.retargetingDeleteService = retargetingDeleteService;
    }

    public MassResult<Long> add(List<InternalAdGroupAddItem> addItems,
                                InternalAdGroupOperationContainer operationContainer) {
        var operation = getAddOperation(operationContainer, addItems);
        return operation.prepareAndApply();
    }

    public NotVeryComplexInternalAdGroupAddOperation getAddOperation(
            InternalAdGroupOperationContainer operationContainer,
            List<InternalAdGroupAddItem> addItems
    ) {
        UidAndClientId owner = operationContainer.getOwner();
        int shard = shardHelper.getShardByClientIdStrictly(owner.getClientId());
        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(owner.getClientId());
        var clientCurrency = clientService.getWorkCurrency(owner.getClientId());

        return new NotVeryComplexInternalAdGroupAddOperation(adGroupService,
                adGroupAdditionalTargetingsAddOperationFactory, retargetingConditionOperationFactory,
                targetInterestService, operationContainer, shard, clientCurrency, geoTree, addItems);
    }

    public MassResult<Long> update(List<InternalAdGroupUpdateItem> updateItems,
                                   InternalAdGroupOperationContainer operationContainer) {
        var operation = getUpdateOperation(operationContainer, updateItems);
        return operation.prepareAndApply();
    }

    public NotVeryComplexInternalAdGroupUpdateOperation getUpdateOperation(
            InternalAdGroupOperationContainer operationContainer,
            List<InternalAdGroupUpdateItem> updateItems
    ) {
        UidAndClientId owner = operationContainer.getOwner();
        GeoTree geoTree = clientGeoService.getClientTranslocalGeoTree(owner.getClientId());
        var clientCurrency = clientService.getWorkCurrency(owner.getClientId());
        return new NotVeryComplexInternalAdGroupUpdateOperation(shardHelper, adGroupService,
                adGroupAdditionalTargetingGroupUpdateOperationFactory,
                retargetingConditionOperationFactory, retargetingRepository,
                targetInterestService, retargetingDeleteService,
                operationContainer, clientCurrency,
                geoTree,
                updateItems);
    }
}
