package ru.yandex.direct.core.entity.adgroup.service.complex.internal;

import java.time.LocalDateTime;

import ru.yandex.direct.core.entity.StatusBsSynced;
import ru.yandex.direct.core.entity.retargeting.Constants;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;
import ru.yandex.direct.currency.Currencies;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.dbutil.model.ClientId;

public class InternalAdGroupsUtils {
    public static RetargetingCondition convertRetargetingCondition(ClientId clientId, RetargetingConditionBase rcb,
                                                                   LocalDateTime now) {
        RetargetingCondition retargetingCondition = new RetargetingCondition();
        retargetingCondition
                .withId(rcb.getId())
                .withClientId(clientId.asLong())
                .withName(rcb.getName())
                .withType(rcb.getType())
                .withDescription(rcb.getDescription())
                .withDeleted(rcb.getDeleted())
                .withLastChangeTime(now)
                .withAvailable(rcb.getAvailable())
                .withRules(rcb.getRules())
                .withInterest(rcb.getInterest())
                .withTargetInterest(rcb.getTargetInterest());
        return retargetingCondition;
    }

    public static TargetInterest createTargetInterest(Long campaignId, Long adGroupId, Long retargetingConditionId,
                                                      LocalDateTime now) {
        return new TargetInterest()
                .withAdGroupId(adGroupId)
                .withCampaignId(campaignId)
                .withRetargetingConditionId(retargetingConditionId)
                // на внутренних кампаниях всегда RUB
                .withPriceContext(Currencies.getCurrency(CurrencyCode.RUB).getMinPrice())
                .withAutobudgetPriority(Constants.DEFAULT_AUTOBUDGET_PRIORITY)
                .withIsSuspended(Boolean.FALSE)
                .withLastChangeTime(now)
                .withStatusBsSynced(StatusBsSynced.NO);
    }
}
