package ru.yandex.direct.core.entity.adgroup.service.complex.mcbanner;

import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.container.ComplexMcBannerAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.BidModifiersLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.ComplexBannersLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.KeywordLogicSupplier;
import ru.yandex.direct.core.entity.banner.container.ComplexBanner;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.keyword.service.KeywordOperationFactory;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

public class ComplexMcBannerAdGroupAddOperation extends ComplexAdGroupAddOperation<ComplexMcBannerAdGroup> {

    private final AddComplexMcBannerAdGroupValidationService addValidationService;
    private final ClientId clientId;

    private ComplexBannersLogicSupplier<ComplexMcBannerAdGroup> bannersLogicSupplier;
    private KeywordLogicSupplier<ComplexMcBannerAdGroup> keywordLogicSupplier;
    private BidModifiersLogicSupplier<ComplexMcBannerAdGroup> bidModifiersLogicSupplier;

    /**
     * @param showConditionAutoPrices      включает режим автоматического вычисления недостающих ставок в условиях
     *                                     показов
     * @param showConditionAutoPriceParams параметры для автоматического вычисления недостающих ставок в условиях
     *                                     показов. Должен быть не {@code null},
     *                                     если {@code showConditionAutoPrices == true}
     */
    public ComplexMcBannerAdGroupAddOperation(boolean saveDraft,
                                              AdGroupService adGroupService,
                                              KeywordOperationFactory keywordOperationFactory,
                                              BannersAddOperationFactory bannersAddOperationFactory,
                                              VcardService vcardService, SitelinkSetService sitelinkSetService,
                                              BidModifierService bidModifierService,
                                              ComplexBidModifierService complexBidModifierService,
                                              AddComplexMcBannerAdGroupValidationService addValidationService,
                                              CampaignRepository campaignRepository,
                                              List<ComplexMcBannerAdGroup> complexAdGroups, GeoTree geoTree,
                                              boolean showConditionAutoPrices,
                                              @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                              long operatorUid, ClientId clientId, long clientUid, int shard) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId, true);
        this.addValidationService = addValidationService;
        this.clientId = clientId;

        ShowConditionFixedAutoPrices showConditionFixedAutoPrices = null;
        if (showConditionAutoPrices) {
            checkArgument(showConditionAutoPriceParams != null,
                    "showConditionAutoPriceParams must be specified in showConditionAutoPrices mode");
            showConditionFixedAutoPrices = showConditionAutoPriceParams.getFixedAutoPrices();
        }

        bannersLogicSupplier = new ComplexBannersLogicSupplier<>(complexAdGroups,
                ComplexMcBannerAdGroup.COMPLEX_BANNERS,
                ComplexBanner.BANNER, bannersAddOperationFactory, vcardService, sitelinkSetService,
                operatorUid, clientId, saveDraft, DatabaseMode.ONLY_MYSQL);
        keywordLogicSupplier = new KeywordLogicSupplier<>(complexAdGroups, ComplexMcBannerAdGroup.KEYWORDS,
                keywordOperationFactory, showConditionAutoPrices, showConditionFixedAutoPrices,
                operatorUid, clientId, clientUid);
        bidModifiersLogicSupplier =
                new BidModifiersLogicSupplier<>(complexAdGroups, ComplexMcBannerAdGroup.COMPLEX_BID_MODIFIER,
                        campaignRepository, bidModifierService, complexBidModifierService, operatorUid, clientId,
                        shard);
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);

        keywordLogicSupplier.prepare(adGroupsResult);
        bannersLogicSupplier.prepare(adGroupsResult);
        bidModifiersLogicSupplier.prepare(adGroupsResult);
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult =
                addValidationService.validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "AddComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> addAdGroupsResult) {
        bannersLogicSupplier.apply(addAdGroupsResult);
        // Применение ключевых фраз должно осуществляться только после применения баннеров,
        // так как внутри осуществляется извлечение из базы баннеров для похода в торги.
        // Потенциальная точка рефакторинга.
        keywordLogicSupplier.apply(addAdGroupsResult);
        bidModifiersLogicSupplier.apply(addAdGroupsResult);
    }
}
