package ru.yandex.direct.core.entity.adgroup.service.complex.mobilecontent;

import java.util.Collections;
import java.util.List;
import java.util.Set;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.container.ComplexMobileContentAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.repository.AdGroupRepository;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BidModifierLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.ComplexBannerLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.KeywordLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.RelevanceMatchLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.RetargetingLogicSupplier;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.keyword.repository.KeywordRepository;
import ru.yandex.direct.core.entity.keyword.service.KeywordModifyOperationFactory;
import ru.yandex.direct.core.entity.relevancematch.repository.RelevanceMatchRepository;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

public class ComplexMobileContentAdGroupUpdateOperation extends ComplexAdGroupUpdateOperation<ComplexMobileContentAdGroup> {

    private final UpdateComplexMobileContentAdGroupValidationService updateValidationService;
    private final ClientId clientId;

    private KeywordLogicSupplier<ComplexMobileContentAdGroup> keywordLogicSupplier;
    private BidModifierLogicSupplier<ComplexMobileContentAdGroup> bidModifierLogicSupplier;
    private RelevanceMatchLogicSupplier<ComplexMobileContentAdGroup> relevanceMatchLogicSupplier;
    private RetargetingLogicSupplier<ComplexMobileContentAdGroup> retargetingLogicSupplier;
    private ComplexBannerLogicSupplier<ComplexMobileContentAdGroup> bannerLogicSupplier;

    /**
     * @param showConditionAutoPrices      включает режим автоматического вычисления недостающих ставок в условиях
     *                                     показов
     * @param showConditionAutoPriceParams параметры для автоматического вычисления недостающих ставок в условиях
     *                                     показов. Должен быть не {@code null}, если
     *                                     {@code showConditionAutoPrices == true}
     */
    public ComplexMobileContentAdGroupUpdateOperation(boolean saveDraft,
                                                      AdGroupService adGroupService,
                                                      UpdateComplexMobileContentAdGroupValidationService updateValidationService,
                                                      KeywordModifyOperationFactory keywordModifyOperationFactory,
                                                      RelevanceMatchService relevanceMatchService,
                                                      RetargetingService retargetingService,
                                                      BidModifierService bidModifierService,
                                                      ComplexBidModifierService complexBidModifierService,
                                                      BannersAddOperationFactory bannersAddOperationFactory,
                                                      BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                                      VcardService vcardService,
                                                      SitelinkSetService sitelinkSetService,
                                                      CampaignRepository campaignRepository,
                                                      AdGroupRepository adGroupRepository,
                                                      KeywordRepository keywordRepository,
                                                      RelevanceMatchRepository relevanceMatchRepository,
                                                      List<ComplexMobileContentAdGroup> complexAdGroups,
                                                      GeoTree geoTree,
                                                      boolean showConditionAutoPrices,
                                                      @Nullable ShowConditionAutoPriceParams showConditionAutoPriceParams,
                                                      long operatorUid, ClientId clientId, long clientUid, int shard) {
        super(Applicability.FULL, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId);
        this.updateValidationService = updateValidationService;
        this.clientId = clientId;

        Set<Long> affectedAdGroupIds = adGroupSimpleMap.keySet();

        ShowConditionFixedAutoPrices showConditionFixedAutoPrices = null;
        if (showConditionAutoPrices) {
            checkArgument(showConditionAutoPriceParams != null,
                    "showConditionAutoPriceParams must be specified in showConditionAutoPrices mode");
            showConditionFixedAutoPrices = showConditionAutoPriceParams.getFixedAutoPrices();
        }
        keywordLogicSupplier = new KeywordLogicSupplier<>(complexAdGroups, ComplexMobileContentAdGroup.KEYWORDS,
                affectedAdGroupIds, keywordModifyOperationFactory, keywordRepository, showConditionAutoPrices,
                showConditionAutoPriceParams, operatorUid, clientId, clientUid, shard);
        relevanceMatchLogicSupplier = new RelevanceMatchLogicSupplier<>(complexAdGroups,
                ComplexMobileContentAdGroup.RELEVANCE_MATCHES, affectedAdGroupIds, relevanceMatchService,
                relevanceMatchRepository, showConditionAutoPrices, showConditionAutoPriceParams, operatorUid,
                clientId, clientUid, shard);
        retargetingLogicSupplier = new RetargetingLogicSupplier<>(complexAdGroups, ComplexMobileContentAdGroup.TARGET_INTERESTS,
                retargetingService, adGroupSimpleMap, Collections.emptyMap(), showConditionAutoPrices,
                showConditionFixedAutoPrices, operatorUid, clientId, clientUid, shard);
        bidModifierLogicSupplier =
                new BidModifierLogicSupplier<>(complexAdGroups, ComplexMobileContentAdGroup.COMPLEX_BID_MODIFIER,
                        affectedAdGroupIds, bidModifierService, complexBidModifierService, campaignRepository,
                        operatorUid, clientId, shard);
        bannerLogicSupplier = new ComplexBannerLogicSupplier<>(complexAdGroups,
                ComplexMobileContentAdGroup.COMPLEX_BANNERS,
                adGroupSimpleMap, bannersAddOperationFactory, bannersUpdateOperationFactory, vcardService,
                sitelinkSetService, operatorUid, clientId, bannersModerationMode);
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);

        keywordLogicSupplier.prepare(adGroupsResult);
        relevanceMatchLogicSupplier.prepare(adGroupsResult);
        retargetingLogicSupplier.prepare(adGroupsResult);
        bidModifierLogicSupplier.prepare(adGroupsResult);
        bannerLogicSupplier.prepare(adGroupsResult);
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult = updateValidationService
                .validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "ComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> updateAdGroupsResult) {
        bannerLogicSupplier.apply(updateAdGroupsResult);
        keywordLogicSupplier.apply(updateAdGroupsResult);
        relevanceMatchLogicSupplier.apply(updateAdGroupsResult);
        retargetingLogicSupplier.apply(updateAdGroupsResult);
        bidModifierLogicSupplier.apply(updateAdGroupsResult);
    }
}
