package ru.yandex.direct.core.entity.adgroup.service.complex.performance;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.adgroup.container.ComplexPerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.adgroup.service.complex.AddComplexAdGroupValidationService;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static java.util.Collections.singleton;
import static ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupValidationCommons.adGroupTypeIsApplicable;
import static ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects.maxBannersInAdGroup;

@Service
@ParametersAreNonnullByDefault
public class AddComplexPerformanceAdGroupValidationService {
    private final AddComplexAdGroupValidationService addValidationService;

    @Autowired
    public AddComplexPerformanceAdGroupValidationService(AddComplexAdGroupValidationService addValidationService) {
        this.addValidationService = addValidationService;
    }

    public ValidationResult<List<AdGroup>, Defect> validateAdGroups(
            ValidationResult<List<AdGroup>, Defect> adGroupsResult,
            List<ComplexPerformanceAdGroup> complexAdGroups) {
        return new ListValidationBuilder<>(adGroupsResult)
                .checkEachBy((index, adGroup) -> {
                    ComplexPerformanceAdGroup complexAdGroup = complexAdGroups.get(index);
                    return validateAdGroup(complexAdGroup);
                }).getResult();
    }

    private ValidationResult<AdGroup, Defect> validateAdGroup(ComplexPerformanceAdGroup complexAdGroup) {
        ModelItemValidationBuilder<AdGroup> vb = ModelItemValidationBuilder.of(complexAdGroup.getAdGroup());

        vb.item(AdGroup.TYPE)
                .check(adGroupTypeIsApplicable(singleton(AdGroupType.PERFORMANCE)));

        vb.list(complexAdGroup.getBanners(), ComplexPerformanceAdGroup.BANNERS.name())
                .check(Constraint.fromPredicate(banners -> banners.size() <= 1, maxBannersInAdGroup(1)))
                .checkBy(banners -> addValidationService.validateBanners(complexAdGroup.getAdGroup(), banners));

        return vb.getResult();
    }
}
