package ru.yandex.direct.core.entity.adgroup.service.complex.performance;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.container.ComplexPerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupAddOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.BannerLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add.BidModifiersLogicSupplier;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkState;

public class ComplexPerformanceAdGroupAddOperation extends ComplexAdGroupAddOperation<ComplexPerformanceAdGroup> {
    private final AddComplexPerformanceAdGroupValidationService addValidationService;

    private final BannerLogicSupplier<ComplexPerformanceAdGroup, PerformanceBannerMain> bannersLogicSupplier;
    private final BidModifiersLogicSupplier<ComplexPerformanceAdGroup> bidModifiersLogicSupplier;

    public ComplexPerformanceAdGroupAddOperation(Applicability applicability, boolean saveDraft,
                                                 AdGroupService adGroupService,
                                                 BidModifierService bidModifierService,
                                                 ComplexBidModifierService complexBidModifierService,
                                                 CampaignRepository campaignRepository,
                                                 List<ComplexPerformanceAdGroup> complexAdGroups,
                                                 GeoTree geoTree,
                                                 long operatorUid, ClientId clientId, int shard,
                                                 AddComplexPerformanceAdGroupValidationService addValidationService,
                                                 BannersAddOperationFactory bannersAddOperationFactory) {
        super(applicability, saveDraft, adGroupService, complexAdGroups, geoTree, operatorUid, clientId, true);
        this.addValidationService = addValidationService;

        bannersLogicSupplier = new BannerLogicSupplier<>(complexAdGroups, ComplexPerformanceAdGroup.BANNERS,
                bannersAddOperationFactory, operatorUid, clientId, saveDraft);
        bidModifiersLogicSupplier =
                new BidModifiersLogicSupplier<>(complexAdGroups, ComplexPerformanceAdGroup.COMPLEX_BID_MODIFIER,
                        campaignRepository, bidModifierService, complexBidModifierService, operatorUid, clientId,
                        shard);
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);

        bannersLogicSupplier.prepare(adGroupsResult);
        bidModifiersLogicSupplier.prepare(adGroupsResult);
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> addAdGroupsResult) {
        bannersLogicSupplier.apply(addAdGroupsResult);
        bidModifiersLogicSupplier.apply(addAdGroupsResult);
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult = addValidationService
                .validateAdGroups(adGroupsResult, complexAdGroups);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "AddComplexAdGroupValidationService must not return operational errors or warnings");
    }
}
