package ru.yandex.direct.core.entity.adgroup.service.complex.performance;

import java.util.List;
import java.util.Set;

import ru.yandex.direct.core.entity.adgroup.container.ComplexPerformanceAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService;
import ru.yandex.direct.core.entity.adgroup.service.ModerationMode;
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupUpdateOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BannerLogicSupplier;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.update.BidModifierLogicSupplier;
import ru.yandex.direct.core.entity.banner.model.PerformanceBannerMain;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.regions.GeoTree;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkState;

public class ComplexPerformanceAdGroupUpdateOperation extends ComplexAdGroupUpdateOperation<ComplexPerformanceAdGroup> {
    private final UpdateComplexPerformanceAdGroupValidationService updateValidationService;

    private BidModifierLogicSupplier<ComplexPerformanceAdGroup> bidModifierLogicSupplier;
    private final BannerLogicSupplier<ComplexPerformanceAdGroup, PerformanceBannerMain> bannersLogicSupplier;

    public ComplexPerformanceAdGroupUpdateOperation(Applicability applicability, ModerationMode moderationMode,
                                                    AdGroupService adGroupService,
                                                    UpdateComplexPerformanceAdGroupValidationService updateValidationService,
                                                    BannersAddOperationFactory bannersAddOperationFactory,
                                                    BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                                    BidModifierService bidModifierService,
                                                    ComplexBidModifierService complexBidModifierService,
                                                    CampaignRepository campaignRepository,
                                                    List<ComplexPerformanceAdGroup> complexAdGroups,
                                                    GeoTree geoTree,
                                                    boolean useBidModifiers,
                                                    long operatorUid,
                                                    ClientId clientId,
                                                    int shard) {
        super(applicability, moderationMode, adGroupService, complexAdGroups, geoTree, operatorUid, clientId);
        this.updateValidationService = updateValidationService;

        Set<Long> affectedAdGroupIds = adGroupSimpleMap.keySet();

        if (useBidModifiers) {
            bidModifierLogicSupplier =
                    new BidModifierLogicSupplier<>(complexAdGroups, ComplexPerformanceAdGroup.COMPLEX_BID_MODIFIER,
                            affectedAdGroupIds, bidModifierService, complexBidModifierService, campaignRepository,
                            operatorUid, clientId, shard);
        }

        bannersLogicSupplier = new BannerLogicSupplier<>(complexAdGroups, ComplexPerformanceAdGroup.BANNERS,
                bannersAddOperationFactory, bannersUpdateOperationFactory, operatorUid, clientId, bannersModerationMode);
    }

    @Override
    protected void afterAdGroupsPrepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        validateInterconnections(adGroupsResult);

        if (bidModifierLogicSupplier != null) {
            bidModifierLogicSupplier.prepare(adGroupsResult);
        }

        bannersLogicSupplier.prepare(adGroupsResult);
    }

    private void validateInterconnections(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        ValidationResult<List<AdGroup>, Defect> complexAdGroupsResult = updateValidationService
                .validateAdGroups(adGroupsResult, complexAdGroups, clientId);
        checkState(!complexAdGroupsResult.hasErrors() && !complexAdGroupsResult.hasWarnings(),
                "ComplexAdGroupValidationService must not return operational errors or warnings");
    }

    @Override
    protected void afterAdGroupsApply(MassResult<Long> updateAdGroupsResult) {
        if (bidModifierLogicSupplier != null) {
            bidModifierLogicSupplier.apply(updateAdGroupsResult);
        }

        bannersLogicSupplier.apply(updateAdGroupsResult);
    }
}
