package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperation;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.banner.service.moderation.ModerationMode;
import ru.yandex.direct.core.entity.banner.service.validation.BannerValidationInfo;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.tree.SubOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.operation.tree.TreeOperationUtils.preparePartialModelOperationAndGetValidationResult;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Общая сабоперация добавления баннеров без связанных сущностей
 */
public class AddBannersSubOperation<T extends BannerWithSystemFields> implements SubOperation<T> {

    private List<T> bannersToAdd;
    protected BannersAddOperation bannersAddOperation;
    @Nullable
    private Set<Integer> elementIndexesToApply;

    public AddBannersSubOperation(boolean saveDraft, List<T> banners,
                                  BannersAddOperationFactory bannersAddOperationFactory,
                                  long operatorUid, ClientId clientId, boolean isUcPreValidation,
                                  DatabaseMode databaseMode) {
        checkArgument(banners != null, "sub operation must not be created with null banners list");

        bannersToAdd = banners;

        if (bannersToAdd.isEmpty()) {
            return;
        }

        bannersAddOperation = bannersAddOperationFactory
                .createPartialAddOperationAsPartOfComplexOperation(mapList(bannersToAdd, Function.identity()),
                        operatorUid, clientId, saveDraft ? ModerationMode.FORCE_SAVE_DRAFT : ModerationMode.FORCE_MODERATE,
                        isUcPreValidation, databaseMode);
    }

    public ValidationResult<List<T>, Defect> prepare() {
        if (bannersAddOperation == null) {
            return new ValidationResult<>(bannersToAdd);
        }

        ValidationResult<List<T>, Defect> validationResult =
                preparePartialModelOperationAndGetValidationResult(bannersAddOperation, bannersToAdd);

        afterBannersPrepare(validationResult);

        return validationResult;
    }

    protected void afterBannersPrepare(ValidationResult<List<T>, Defect> validationResult) {
    }

    public void setElementIndexesToApply(@Nullable Set<Integer> elementIndexesToApply) {
        this.elementIndexesToApply = elementIndexesToApply;
    }

    public void setAdGroups(Map<Integer, AdGroupForBannerOperation> adGroups) {
        if (bannersAddOperation != null) {
            bannersAddOperation.setAdGroupsInfo(adGroups);
        }
    }

    public void setAdGroupsIds(Map<Integer, Long> adGroupIdsByIndex) {
        if (bannersAddOperation != null) {
            bannersAddOperation.setAdGroupIds(adGroupIdsByIndex);
        }
    }

    public void setBannerValidationInfo(Map<Integer, BannerValidationInfo> bannersValidationInfoMap) {
        if (bannersAddOperation != null) {
            bannersAddOperation.setBannerValidationInfo(bannersValidationInfoMap);
        }
    }

    public void setContentPromotionBannerValidationInfo(
            Map<Integer, ContentPromotionAdgroupType> bannersValidationInfoMap) {
        if (bannersAddOperation != null) {
            bannersAddOperation.setContentPromotionAdGroupTypeMap(bannersValidationInfoMap);
        }
    }


    public void apply() {
        if (bannersAddOperation == null) {
            return;
        }

        beforeBannersApply();

        if (elementIndexesToApply != null) {
            bannersAddOperation.apply(elementIndexesToApply);
        } else {
            bannersAddOperation.apply();
        }
    }

    protected void beforeBannersApply() {
    }
}
