package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.common.AddSitelinkSetsSubOperation;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.common.AddVcardsSubOperation;
import ru.yandex.direct.core.entity.banner.container.ComplexBanner;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.vcard.model.Vcard;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.tree.ItemSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.service.validation.type.BannerTypeValidationPredicates.isTextBanner;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

/**
 * Сабоперация добавления баннеров с визитками и сайтлинками
 */
public class AddComplexBannersSubOperation extends AddBannersSubOperation<BannerWithSystemFields> {

    private ItemSubOperationExecutor<BannerWithSystemFields, Vcard, AddVcardsSubOperation> vcardExecutor;
    private ItemSubOperationExecutor<BannerWithSystemFields, SitelinkSet, AddSitelinkSetsSubOperation> sitelinkSetExecutor;

    public AddComplexBannersSubOperation(List<ComplexBanner> complexBanners,
                                         BannersAddOperationFactory bannersAddOperationFactory,
                                         VcardService vcardService, SitelinkSetService sitelinkSetService,
                                         long operatorUid, ClientId clientId,
                                         boolean saveDraft, boolean isUcPreValidation,
                                         DatabaseMode databaseMode) {
        super(saveDraft, mapList(complexBanners, ComplexBanner::getBanner), bannersAddOperationFactory, operatorUid,
                clientId, isUcPreValidation, databaseMode);

        createVcardExecutor(vcardService, complexBanners, operatorUid, clientId);
        createSitelinkExecutor(sitelinkSetService, complexBanners, clientId);
    }

    private void createVcardExecutor(VcardService vcardService, List<ComplexBanner> complexBanners, long operatorUid,
                                     ClientId clientId) {
        SubOperationCreator<Vcard, AddVcardsSubOperation> operationCreator =
                vcards -> new AddVcardsSubOperation(vcardService, vcards, operatorUid, clientId);
        vcardExecutor = ItemSubOperationExecutor.builder()
                .withFakeParents(complexBanners)
                .withChildProperty(ComplexBanner.VCARD)
                .withFiltering(complexBanner -> isTextBanner(complexBanner.getBanner()))
                .createSubOperationBy(operationCreator);
    }

    private void createSitelinkExecutor(SitelinkSetService sitelinkSetService, List<ComplexBanner> complexBanners,
                                        ClientId clientId) {
        SubOperationCreator<SitelinkSet, AddSitelinkSetsSubOperation> operationCreator =
                sitelinkSets -> new AddSitelinkSetsSubOperation(sitelinkSetService, sitelinkSets, clientId);
        sitelinkSetExecutor = ItemSubOperationExecutor.builder()
                .withFakeParents(complexBanners)
                .withChildProperty(ComplexBanner.SITELINK_SET)
                .withFiltering(complexBanner -> isTextBanner(complexBanner.getBanner()))
                .createSubOperationBy(operationCreator);
    }

    @Override
    protected void afterBannersPrepare(ValidationResult<List<BannerWithSystemFields>, Defect> validationResult) {
        vcardExecutor.prepare(validationResult);
        sitelinkSetExecutor.prepare(validationResult);
    }

    @Override
    protected void beforeBannersApply() {
        applyVcards();
        applySitelinkSets();
    }

    private void applyVcards() {
        vcardExecutor.apply();
        var vcards = vcardExecutor.getSubOperation().getVcards();
        Map<Integer, Integer> bannerIndexToVcardIndex = vcardExecutor.getIndexMap();
        Map<Integer, Vcard> bannerIndexToVcardId = EntryStream.of(bannerIndexToVcardIndex)
                .mapValues(vcards::get)
                .toMap();
        bannersAddOperation.setVcards(bannerIndexToVcardId);
    }

    private void applySitelinkSets() {
        sitelinkSetExecutor.apply();
        List<SitelinkSet> sitelinkSets = sitelinkSetExecutor.getSubOperation().getSitelinkSets();
        Map<Integer, Integer> bannerIndexToSitelinkSetIndex = sitelinkSetExecutor.getIndexMap();
        Map<Integer, SitelinkSet> bannerIndexToSitelinkSetId = EntryStream.of(bannerIndexToSitelinkSetIndex)
                .mapValues(sitelinkSets::get)
                .toMap();
        bannersAddOperation.setSitelinkSets(bannerIndexToSitelinkSetId);
    }
}
