package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add

import ru.yandex.direct.core.entity.offerretargeting.container.AdGroupInfoForOfferRetargetingAdd
import ru.yandex.direct.core.entity.offerretargeting.model.OfferRetargeting
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingAddOperation
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingService
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.operation.tree.SubOperation
import ru.yandex.direct.operation.tree.TreeOperationUtils.prepareNullableOperationAndGetValidationResult
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

class AddOfferRetargetingsSubOperation(
    val offerRetargetingService: OfferRetargetingService,
    val clientCurrency: Currency,
    val offerRetargetings: List<OfferRetargeting>,
    val operatorUid: Long, val clientId: ClientId
) : SubOperation<OfferRetargeting> {
    private val offerRetargetingAddOperation: OfferRetargetingAddOperation? =
        if (offerRetargetings.isEmpty()) {
            null
        } else {
            offerRetargetingService.createAddOperationWithNonExistingAdGroups(
                offerRetargetings, clientId, operatorUid, clientCurrency
            )
        }

    fun setAdGroupInfos(adGroupInfos: Map<Int, AdGroupInfoForOfferRetargetingAdd>) {
        offerRetargetingAddOperation?.setAdGroupInfos(adGroupInfos)
    }

    fun setAdGroupIds(adGroupIds: Map<Int, Long>) {
        offerRetargetingAddOperation?.setAdGroupsIds(adGroupIds)
    }

    override fun prepare(): ValidationResult<MutableList<OfferRetargeting>, Defect<Any>> {
        return prepareNullableOperationAndGetValidationResult(
            offerRetargetingAddOperation,
            offerRetargetings
        )
    }

    override fun apply() {
        offerRetargetingAddOperation?.apply()
    }
}
