package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.relevancematch.container.AdGroupInfoForRelevanceMatchAdd;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatch;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchAddOperation;
import ru.yandex.direct.core.entity.relevancematch.service.RelevanceMatchService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionAutoPriceParams;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.tree.SubOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.operation.tree.TreeOperationUtils.prepareNullableOperationAndGetValidationResult;

public class AddRelevanceMatchesSubOperation implements SubOperation<RelevanceMatch> {
    private final List<RelevanceMatch> relevanceMatches;

    private RelevanceMatchAddOperation relevanceMatchAddOperation;

    /**
     * @param autoPrices      включает режим {@code autoPrices}, см. коммент к классу {@link RelevanceMatchAddOperation}
     * @param autoPriceParams параметры для автоматического выставления отсутствующих ставок. Должен быть
     *                        не {@code null}, если {@code autoPrices == true}
     */
    public AddRelevanceMatchesSubOperation(RelevanceMatchService relevanceMatchService,
                                           Currency clientCurrency,
                                           List<RelevanceMatch> relevanceMatches,
                                           boolean autoPrices, @Nullable ShowConditionAutoPriceParams autoPriceParams,
                                           long operatorUid, ClientId clientId) {
        checkArgument(relevanceMatches != null, "sub operation must not be created with null relevance matches list");

        this.relevanceMatches = relevanceMatches;
        if (relevanceMatches.isEmpty()) {
            return;
        }

        this.relevanceMatchAddOperation = relevanceMatchService
                .createOperationWithNonExistingAdGroups(clientCurrency, clientId, operatorUid, relevanceMatches,
                        autoPrices, autoPriceParams);
    }

    public void setAdGroupInfoForRelevanceMatchAdd(
            Map<Integer, AdGroupInfoForRelevanceMatchAdd> adGroupInfoForRelevanceMatchAdd) {
        if (relevanceMatchAddOperation != null) {
            relevanceMatchAddOperation.setAdGroupInfoForRelevanceMatchAdd(adGroupInfoForRelevanceMatchAdd);
        }
    }

    public void setAdGroupsIds(Map<Integer, Long> adGroupIds) {
        if (relevanceMatchAddOperation != null) {
            relevanceMatchAddOperation.setAdGroupsIds(adGroupIds);
        }
    }

    @Override
    public ValidationResult<List<RelevanceMatch>, Defect> prepare() {
        return prepareNullableOperationAndGetValidationResult(relevanceMatchAddOperation, relevanceMatches);
    }

    @Override
    public void apply() {
        if (relevanceMatchAddOperation != null) {
            relevanceMatchAddOperation.apply();
        }
    }
}
