package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.List;

import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.service.AddRetargetingConditionsOperation;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingConditionOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.tree.SubOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.operation.tree.TreeOperationUtils.prepareNullableOperationAndGetValidationResult;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class AddRetargetingConditionsSubOperation implements SubOperation<RetargetingConditionBase> {

    private final List<RetargetingConditionBase> retargetingConditions;

    private AddRetargetingConditionsOperation addRetargetingConditionsOperation;

    public AddRetargetingConditionsSubOperation(
            RetargetingConditionOperationFactory retargetingConditionOperationFactory,
            List<RetargetingConditionBase> retargetingConditions, ClientId clientId) {
        checkArgument(retargetingConditions != null,
                "sub operation must not be created with null retargetings condition list");

        this.retargetingConditions = retargetingConditions;
        if (retargetingConditions.isEmpty()) {
            return;
        }

        addRetargetingConditionsOperation = retargetingConditionOperationFactory
                .createAddOperation(Applicability.FULL,
                        mapList(retargetingConditions, rc -> (RetargetingCondition) rc.withClientId(clientId.asLong())),
                        clientId);

    }

    public List<RetargetingConditionBase> getRetargetingConditions() {
        return retargetingConditions;
    }

    @Override
    public ValidationResult<List<RetargetingConditionBase>, Defect> prepare() {
        return prepareNullableOperationAndGetValidationResult(addRetargetingConditionsOperation, retargetingConditions);
    }

    @Override
    public void apply() {
        if (addRetargetingConditionsOperation != null) {
            addRetargetingConditionsOperation.apply();
        }
    }
}
