package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.List;
import java.util.Map;

import javax.annotation.Nullable;

import ru.yandex.direct.core.entity.retargeting.container.RetargetingAdGroupInfo;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.TargetInterest;
import ru.yandex.direct.core.entity.retargeting.service.AddRetargetingsOperation;
import ru.yandex.direct.core.entity.retargeting.service.RetargetingService;
import ru.yandex.direct.core.entity.showcondition.container.ShowConditionFixedAutoPrices;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.operation.Applicability;
import ru.yandex.direct.operation.tree.SubOperation;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.operation.tree.TreeOperationUtils.prepareNullableOperationAndGetValidationResult;

public class AddRetargetingsSubOperation implements SubOperation<TargetInterest> {

    private final List<TargetInterest> targetInterests;

    private AddRetargetingsOperation addRetargetingsOperation;

    /**
     * @param autoPrices      включает режим {@code autoPrices}, см. коммент к классу {@link AddRetargetingsOperation}
     * @param fixedAutoPrices Контейнер с фиксированными ставками, которые нужно выставить у ретаргетинга, если ставка
     *                        не была явно указана. Ставки могут быть не для всех ретаргетингов.
     *                        Должен быть не {@code null}, если {@code autoPrices == true}.
     */
    public AddRetargetingsSubOperation(RetargetingService retargetingService,
                                       List<TargetInterest> targetInterests,
                                       boolean retargetingConditionsNonexistentOnPrepare,
                                       boolean autoPrices, @Nullable ShowConditionFixedAutoPrices fixedAutoPrices,
                                       long operatorUid, ClientId clientId, long clientUid) {
        checkArgument(targetInterests != null, "sub operation must not be created with null retargetings list");

        this.targetInterests = targetInterests;
        if (targetInterests.isEmpty()) {
            return;
        }

        this.addRetargetingsOperation = retargetingService
                .createAddOperation(Applicability.FULL, true, retargetingConditionsNonexistentOnPrepare,
                        targetInterests,
                        autoPrices, fixedAutoPrices,
                        operatorUid, clientId, clientUid);
    }

    public void setRetargetingsAdGroupsInfo(Map<Integer, RetargetingAdGroupInfo> retargetingsAdGroupsInfo) {
        if (addRetargetingsOperation != null) {
            addRetargetingsOperation.setNonexistentAdGroupsInfo(retargetingsAdGroupsInfo);
        }
    }

    public void setAdGroupsIds(Map<Integer, Long> adGroupIds) {
        if (addRetargetingsOperation != null) {
            addRetargetingsOperation.setAdGroupsIds(adGroupIds);
        }
    }

    public void setRetargetingConditions(List<RetargetingCondition> retargetingConditions) {
        if (addRetargetingsOperation != null) {
            addRetargetingsOperation.setNonexistentRetargetingCondition(retargetingConditions);
        }
    }

    public void setRetargetingConditionsIds(List<RetargetingCondition> retargetingConditions) {
        if (addRetargetingsOperation != null) {
            addRetargetingsOperation.setRetargetingConditionsIds(retargetingConditions);
        }
    }

    @Override
    public ValidationResult<List<TargetInterest>, Defect> prepare() {
        return prepareNullableOperationAndGetValidationResult(addRetargetingsOperation, targetInterests);
    }

    @Override
    public void apply() {
        if (addRetargetingsOperation != null) {
            addRetargetingsOperation.apply();
        }
    }
}
