package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class AddSubEntityLogicSupplier<T extends ComplexAdGroup> {
    protected List<T> complexAdGroups;
    protected List<AdGroup> adGroups;

    public AddSubEntityLogicSupplier(List<T> complexAdGroups) {
        this.complexAdGroups = complexAdGroups;
        adGroups = mapList(complexAdGroups, ComplexAdGroup::getAdGroup);
    }

    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
    }

    public void apply(MassResult<Long> addAdGroupsResult) {
    }

}
