package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import one.util.streamex.EntryStream;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupForBannerOperation;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.tree.ListSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.result.Result;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

/**
 * Логика добавления баннеров без связанных объектов в рамках комплексной операции
 */
public class BannerLogicSupplier<T extends ComplexAdGroup, B extends BannerWithSystemFields> extends AddSubEntityLogicSupplier<T> {
    private ListSubOperationExecutor<AdGroup, B, ? extends AddBannersSubOperation<B>> bannerExecutor;

    public BannerLogicSupplier(List<T> complexAdGroups,
                               ModelProperty<? super T, List<B>> bannersProperty,
                               BannersAddOperationFactory bannersAddOperationFactory, long operatorUid,
                               ClientId clientId, boolean saveDraft) {
        super(complexAdGroups);
        createBannerExecutor(bannersProperty, bannersAddOperationFactory, operatorUid, clientId, saveDraft);
    }

    protected BannerLogicSupplier(List<T> complexAdGroups,
                                  ListSubOperationExecutor<AdGroup, B, ?
                                          extends AddBannersSubOperation<B>> bannerExecutor) {
        super(complexAdGroups);
        this.bannerExecutor = bannerExecutor;
    }

    private void createBannerExecutor(ModelProperty<? super T, List<B>> bannersProperty,
                                      BannersAddOperationFactory bannersAddOperationFactory, long operatorUid,
                                      ClientId clientId, boolean saveDraft) {
        SubOperationCreator<B, AddBannersSubOperation<B>> subOperationCreator =
                banners -> new AddBannersSubOperation<>(saveDraft, banners, bannersAddOperationFactory, operatorUid,
                        clientId, false, DatabaseMode.ONLY_MYSQL);

        bannerExecutor = ListSubOperationExecutor.builder()
                .withFakeParents(complexAdGroups)
                .withChildrenProperty(bannersProperty)
                .createSubOperationBy(subOperationCreator);
    }

    public ListSubOperationExecutor<AdGroup, B, ? extends AddBannersSubOperation<B>> getBannerExecutor() {
        return bannerExecutor;
    }

    @Override
    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        Map<Integer, AdGroupForBannerOperation> adGroupInfoByBannerIndex = new HashMap<>();
        bannerExecutor.getIndexMultimap().forEach((adGroupIndex, bannerFlatIndex) ->
                adGroupInfoByBannerIndex.put(bannerFlatIndex, adGroups.get(adGroupIndex)));
        bannerExecutor.getSubOperation().setAdGroups(adGroupInfoByBannerIndex);
        bannerExecutor.prepare(adGroupsResult);
    }

    @Override
    public void apply(MassResult<Long> addAdGroupsResult) {
        Map<Integer, Long> adGroupIdsByBannerIndex = new HashMap<>();
        bannerExecutor.getIndexMultimap().forEach((adGroupIndex, bannerIndex) ->
                adGroupIdsByBannerIndex.put(bannerIndex, addAdGroupsResult.get(adGroupIndex).getResult()));
        bannerExecutor.getSubOperation().setElementIndexesToApply(
                EntryStream.of(bannerExecutor.getIndexMultimap().asMap())
                        .mapKeys(addAdGroupsResult::get)
                        .filterKeys(Result::isSuccessful)
                        .flatMapValues(Collection::stream)
                        .values()
                        .toSet());
        bannerExecutor.getSubOperation().setAdGroupsIds(adGroupIdsByBannerIndex);
        bannerExecutor.apply();
    }
}
