package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.common.SetBidModifiersSubOperation;
import ru.yandex.direct.core.entity.bidmodifier.ComplexBidModifier;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.core.entity.bidmodifiers.service.ComplexBidModifierService;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithType;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.tree.ItemSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class BidModifiersLogicSupplier<T extends ComplexAdGroup> extends AddSubEntityLogicSupplier<T> {
    private ItemSubOperationExecutor<AdGroup, ComplexBidModifier, SetBidModifiersSubOperation> bidModifierExecutor;

    private final ModelProperty<? super T, ComplexBidModifier> complexBidModifierProperty;
    private CampaignRepository campaignRepository;
    private final BidModifierService bidModifierService;
    private final ComplexBidModifierService complexBidModifierService;
    private long operatorUid;
    private ClientId clientId;
    private int shard;

    public BidModifiersLogicSupplier(List<T> complexAdGroups,
                                     ModelProperty<? super T, ComplexBidModifier> complexBidModifierProperty,
                                     CampaignRepository campaignRepository, BidModifierService bidModifierService,
                                     ComplexBidModifierService complexBidModifierService, long operatorUid,
                                     ClientId clientId, int shard) {
        super(complexAdGroups);
        this.complexBidModifierProperty = complexBidModifierProperty;
        this.campaignRepository = campaignRepository;
        this.bidModifierService = bidModifierService;
        this.complexBidModifierService = complexBidModifierService;
        this.operatorUid = operatorUid;
        this.clientId = clientId;
        this.shard = shard;
    }

    private void createBidModifiersExecutor(ModelProperty<? super T, ComplexBidModifier> complexBidModifierProperty,
                                            BidModifierService bidModifierService,
                                            ComplexBidModifierService complexBidModifierService) {
        SubOperationCreator<ComplexBidModifier, SetBidModifiersSubOperation> subOperationCreator =
                complexBidModifiers -> new SetBidModifiersSubOperation(clientId, operatorUid, shard,
                        bidModifierService, complexBidModifierService, complexBidModifiers);
        bidModifierExecutor = ItemSubOperationExecutor.builder()
                .withFakeParents(complexAdGroups)
                .withChildProperty(complexBidModifierProperty)
                .createSubOperationBy(subOperationCreator);
    }

    @Override
    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {

        if (bidModifierExecutor == null) {
            createBidModifiersExecutor(complexBidModifierProperty, bidModifierService, complexBidModifierService);
        }

        Set<Long> campaignIds = StreamEx.of(complexAdGroups)
                .map(ComplexAdGroup::getAdGroup)
                .map(AdGroup::getCampaignId)
                .nonNull()
                .toSet();

        Map<Long, CampaignWithType> campaignsWithType =
                campaignRepository.getCampaignsWithTypeByCampaignIds(shard, clientId, campaignIds);
        Map<Integer, CampaignType> bidModifierIndexToCampaignTypeMap = new HashMap<>();
        Map<Integer, AdGroup> bidModifierIndexToAdGroupWithTypeMap = new HashMap<>();
        bidModifierExecutor.getIndexMap().forEach((adGroupIndex, bidModifierIndex) -> {
            ComplexAdGroup complexAdGroup = complexAdGroups.get(adGroupIndex);
            Long campaignId = complexAdGroup.getAdGroup().getCampaignId();
            if (campaignId != null) {
                CampaignWithType campaignWithType = campaignsWithType.get(campaignId);
                if (campaignWithType != null) {
                    bidModifierIndexToCampaignTypeMap.put(bidModifierIndex, campaignWithType.getType());
                }
            }
            bidModifierIndexToAdGroupWithTypeMap.put(bidModifierIndex, complexAdGroup.getAdGroup());
        });

        bidModifierExecutor.getSubOperation().setCampaignTypesBeforePrepare(bidModifierIndexToCampaignTypeMap);
        bidModifierExecutor.getSubOperation().setAdGroupWithTypesBeforePrepare(bidModifierIndexToAdGroupWithTypeMap);
        bidModifierExecutor.prepare(adGroupsResult);
    }

    @Override
    public void apply(MassResult<Long> addAdGroupsResult) {
        Map<Integer, Long> complexIndexToAdGroupIdMap = new HashMap<>();
        Map<Long, Long> adGroupIdToCampaignIdMap = new HashMap<>();
        bidModifierExecutor.getIndexMap().forEach((adGroupIndex, bidModifierIndex) -> {
            ComplexAdGroup complexAdGroup = complexAdGroups.get(adGroupIndex);
            Long adGroupId = addAdGroupsResult.get(adGroupIndex).getResult();
            adGroupIdToCampaignIdMap.put(adGroupId, complexAdGroup.getAdGroup().getCampaignId());
            complexIndexToAdGroupIdMap.put(bidModifierIndex, adGroupId);
        });
        Set<Long> affectedAdGroupIds = new HashSet<>(complexIndexToAdGroupIdMap.values());
        bidModifierExecutor.getSubOperation()
                .setAdGroupsInfoBeforeApply(complexIndexToAdGroupIdMap, adGroupIdToCampaignIdMap,
                        affectedAdGroupIds);

        bidModifierExecutor.apply();
    }
}
