package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.banner.container.ComplexBanner;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersAddOperationFactory;
import ru.yandex.direct.core.entity.banner.service.DatabaseMode;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.core.entity.vcard.service.VcardService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.operation.tree.ListSubOperationExecutor;
import ru.yandex.direct.operation.tree.SubOperationCreator;

import static org.apache.commons.collections4.CollectionUtils.isEmpty;
import static ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupModelUtils.checkComplexBannersConsistency;

/**
 * Логика добавления комплексных баннеров в рамках комплексной операции. Обрабатываются так же привязанные к баннеру
 * визитка и сайтлинки
 */
public class ComplexBannersLogicSupplier<T extends ComplexAdGroup> extends BannerLogicSupplier<T, BannerWithSystemFields> {
    private ModelProperty<? super T, List<ComplexBanner>> complexBannerProperty;

    public ComplexBannersLogicSupplier(List<T> complexAdGroups,
                                       ModelProperty<? super T, List<ComplexBanner>> complexBannerProperty,
                                       ModelProperty<? super ComplexBanner, BannerWithSystemFields> realBannerProperty,
                                       BannersAddOperationFactory bannersAddOperationFactory,
                                       VcardService vcardService,
                                       SitelinkSetService sitelinkSetService,
                                       long operatorUid, ClientId clientId, boolean saveDraft,
                                       DatabaseMode databaseMode) {
        super(complexAdGroups,
                createBannerExecutor(complexAdGroups, complexBannerProperty, realBannerProperty,
                        bannersAddOperationFactory, vcardService, sitelinkSetService, operatorUid, clientId, saveDraft,
                        databaseMode)
        );
        checkComplexBannersConsistency(complexAdGroups, complexBannerProperty);
        this.complexBannerProperty = complexBannerProperty;
        fillVcardsCampaignId();
    }

    //для передачи результата работы в конструктор супер класса, этот метод должен быть статическим
    private static <T extends ComplexAdGroup> ListSubOperationExecutor<AdGroup, BannerWithSystemFields,
            AddComplexBannersSubOperation> createBannerExecutor(
            List<T> complexAdGroups, ModelProperty<? super T, List<ComplexBanner>> complexBannerProperty,
            ModelProperty<? super ComplexBanner, BannerWithSystemFields> realBannerProperty,
            BannersAddOperationFactory bannersAddOperationFactory,
            VcardService vcardService, SitelinkSetService sitelinkSetService, long operatorUid, ClientId clientId,
            boolean saveDraft, DatabaseMode databaseMode) {
        SubOperationCreator<ComplexBanner, AddComplexBannersSubOperation> subOperationCreator =
                complexBanners -> new AddComplexBannersSubOperation(complexBanners, bannersAddOperationFactory,
                        vcardService, sitelinkSetService,
                        operatorUid, clientId, saveDraft, false, databaseMode);

        return ListSubOperationExecutor.builder()
                .withFakeParents(complexAdGroups)
                .withFakeChildrenProperty(complexBannerProperty)
                .withRealChildProperty(realBannerProperty)
                .createSubOperationBy(subOperationCreator);
    }

    private void fillVcardsCampaignId() {
        for (T complexAdGroup : complexAdGroups) {

            Long campaignId = complexAdGroup.getAdGroup().getCampaignId();

            List<ComplexBanner> complexBanners = complexBannerProperty.get(complexAdGroup);
            if (!isEmpty(complexBanners)) {
                for (ComplexBanner banner : complexBanners) {

                    if (banner.getVcard() != null) {
                        banner.getVcard().withCampaignId(campaignId);
                    }
                }
            }
        }
    }
}
