package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add;

import java.util.List;

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup;
import ru.yandex.direct.core.entity.adgroup.container.ComplexCpmAdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.AdGroupWithUsersSegments;
import ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.UsersSegmentsValidationUtil;
import ru.yandex.direct.core.entity.userssegments.service.UsersSegmentService;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.adgroup.AdGroupWithUsersSegmentsHelper.complexCpmAdGroupsToMap;


public class CpmUsersSegmentsLogicSupplier extends AddSubEntityLogicSupplier<ComplexCpmAdGroup> {
    private final UsersSegmentService usersSegmentService;
    private final int shard;

    public CpmUsersSegmentsLogicSupplier(List<ComplexCpmAdGroup> complexAdGroups,
                                         UsersSegmentService usersSegmentService,
                                         int shardId) {
        super(complexAdGroups);
        this.usersSegmentService = usersSegmentService;
        this.shard = shardId;
        clearAdGroupsSegments(complexAdGroups);
    }

    /**
     *  Обнуляет usersSegments, так как для комплексных групп они передаются в самой комплексной группе,
     *  и если они так же будут и в обычной группе, то сегменты задублируются. Раньше в операции добавлени обычных групп
     *  сегменты не учитывались, и обнулять их было не нужно. Теперь они учитываются и в комплексных операциях
     *  их нужно обнулять
     *
     * @param complexAdGroups список комплексных групп
     */
    private static <T extends ComplexAdGroup> void clearAdGroupsSegments(List<T> complexAdGroups) {
        complexAdGroups.stream()
                .filter(complexAdGroup -> complexAdGroup.getAdGroup() instanceof AdGroupWithUsersSegments)
                .forEach(complexAdGroup ->
                        ((AdGroupWithUsersSegments) complexAdGroup.getAdGroup()).setUsersSegments(null));
    }

    @Override
    public void prepare(ValidationResult<List<AdGroup>, Defect> adGroupsResult) {
        UsersSegmentsValidationUtil.validateCpmUserSegmentsOnInsert(adGroupsResult, complexAdGroups);
    }

    @Override
    public void apply(MassResult<Long> addAdGroupsResult) {
        if (complexAdGroups == null || complexAdGroups.isEmpty()) {
            return;
        }
        usersSegmentService.addSegments(shard, complexCpmAdGroupsToMap(complexAdGroups));
    }
}
