package ru.yandex.direct.core.entity.adgroup.service.complex.suboperation.add

import ru.yandex.direct.core.entity.adgroup.container.ComplexAdGroup
import ru.yandex.direct.core.entity.adgroup.model.AdGroup
import ru.yandex.direct.core.entity.adgroup.service.complex.ComplexAdGroupModelUtils.checkOfferRetargetingsConsistency
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository
import ru.yandex.direct.core.entity.offerretargeting.container.AdGroupInfoForOfferRetargetingAdd
import ru.yandex.direct.core.entity.offerretargeting.model.OfferRetargeting
import ru.yandex.direct.core.entity.offerretargeting.service.OfferRetargetingService
import ru.yandex.direct.currency.Currency
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.model.ModelProperty
import ru.yandex.direct.operation.tree.ListSubOperationExecutor
import ru.yandex.direct.operation.tree.SubOperationCreator
import ru.yandex.direct.result.MassResult
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

class OfferRetargetingLogicSupplier<T : ComplexAdGroup>(
    complexAdGroups: List<T>,
    val offerRetargetingProperty: ModelProperty<in T, List<OfferRetargeting>>,
    val campaignRepository: CampaignRepository,
    val offerRetargetingService: OfferRetargetingService,
    val clientCurrency: Currency,
    val operatorUid: Long,
    val clientId: ClientId,
    val shard: Int
) : AddSubEntityLogicSupplier<T>(complexAdGroups) {
    private val offerRetargetingExecutor: ListSubOperationExecutor<AdGroup, OfferRetargeting, AddOfferRetargetingsSubOperation>

    init {
        checkOfferRetargetingsConsistency(complexAdGroups, offerRetargetingProperty)
        val subOperationCreator = SubOperationCreator { offerRetargetings: List<OfferRetargeting> ->
            AddOfferRetargetingsSubOperation(
                offerRetargetingService, clientCurrency,
                offerRetargetings, operatorUid, clientId
            )
        }
        offerRetargetingExecutor = ListSubOperationExecutor.builder()
            .withFakeParents(complexAdGroups)
            .withChildrenProperty(offerRetargetingProperty)
            .createSubOperationBy(subOperationCreator)
    }

    override fun prepare(adGroupsResult: ValidationResult<List<AdGroup>, Defect<*>>) {
        val campaignIds: Set<Long> = adGroups.mapTo(mutableSetOf()) { it.campaignId }
        val campaigns = campaignRepository.getClientsCampaignsByIds(shard, clientId, campaignIds)
        val campaignsMap = campaigns.associateBy { it.id }

        val adGroupInfos = offerRetargetingExecutor.indexMultimap.entries()
            .associate { (adGroupIndex: Int, offerRetIndex: Int) ->
                val campaignId = adGroups[adGroupIndex]!!.campaignId
                offerRetIndex to AdGroupInfoForOfferRetargetingAdd(adGroupIndex, campaignsMap[campaignId]!!)
            }
        offerRetargetingExecutor.subOperation.setAdGroupInfos(adGroupInfos)
        offerRetargetingExecutor.prepare(adGroupsResult)
    }

    override fun apply(addAdGroupsResult: MassResult<Long>) {
        val adGroupIds = offerRetargetingExecutor.indexMultimap.entries()
            .associate { (adGroupIndex, offerRetIndex) ->
                offerRetIndex to addAdGroupsResult[adGroupIndex].result
            }
        offerRetargetingExecutor.subOperation.setAdGroupIds(adGroupIds)
        offerRetargetingExecutor.apply()
    }
}
